/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.search;

import com.datastax.dse.driver.api.core.data.time.DateRangePrecision;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateRangeUtil {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final ImmutableMap<DateRangePrecision, Integer> FIELD_BY_PRECISION = ImmutableMap.builder().put(DateRangePrecision.YEAR, 1).put(DateRangePrecision.MONTH, 2).put(DateRangePrecision.DAY, 5).put(DateRangePrecision.HOUR, 11).put(DateRangePrecision.MINUTE, 12).put(DateRangePrecision.SECOND, 13).put(DateRangePrecision.MILLISECOND, 14).build();

    @NonNull
    public static ZonedDateTime roundDown(@NonNull ZonedDateTime date, @NonNull ChronoUnit unit) {
        switch (unit) {
            case YEARS: {
                return date.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
            }
            case MONTHS: {
                return date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
            }
            case DAYS: 
            case HOURS: 
            case MINUTES: 
            case SECONDS: 
            case MILLIS: {
                return date.truncatedTo(unit);
            }
        }
        throw new IllegalArgumentException("Unsupported unit for rounding: " + unit);
    }

    @NonNull
    public static ZonedDateTime roundUp(@NonNull ZonedDateTime date, @NonNull ChronoUnit unit) {
        return DateRangeUtil.roundDown(date, unit).plus(1L, unit).minus(1L, ChronoUnit.MILLIS);
    }

    public static Calendar parseCalendar(String source) throws ParseException {
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("Can't parse a null or blank string");
        }
        Calendar calendar = DateRangeUtil.newCalendar();
        if (source.equals("*")) {
            return calendar;
        }
        int offset = 0;
        try {
            int year;
            int lastOffset = source.charAt(source.length() - 1) == 'Z' ? source.length() - 1 : source.length();
            int hyphenIdx = source.indexOf(45, 1);
            if (hyphenIdx < 0) {
                hyphenIdx = lastOffset;
            }
            calendar.set(0, (year = Integer.parseInt(source.substring(offset, hyphenIdx))) <= 0 ? 0 : 1);
            calendar.set(1, year <= 0 ? -1 * year + 1 : year);
            offset = hyphenIdx + 1;
            if (lastOffset < offset) {
                return calendar;
            }
            calendar.set(2, Integer.parseInt(source.substring(offset, offset + 2)) - 1);
            if (lastOffset < (offset += 3)) {
                return calendar;
            }
            calendar.set(5, Integer.parseInt(source.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return calendar;
            }
            calendar.set(11, Integer.parseInt(source.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return calendar;
            }
            calendar.set(12, Integer.parseInt(source.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return calendar;
            }
            calendar.set(13, Integer.parseInt(source.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return calendar;
            }
            calendar.set(14, Integer.parseInt(source.substring(offset, offset + 3)));
            if (lastOffset == (offset += 3)) {
                return calendar;
            }
        }
        catch (Exception e) {
            ParseException pe = new ParseException("Improperly formatted date: " + source, offset);
            pe.initCause(e);
            throw pe;
        }
        throw new ParseException("Improperly formatted date: " + source, offset);
    }

    private static Calendar newCalendar() {
        Calendar calendar = Calendar.getInstance(UTC, Locale.ROOT);
        calendar.clear();
        return calendar;
    }

    @Nullable
    public static DateRangePrecision getPrecision(Calendar calendar) {
        DateRangePrecision lastPrecision = null;
        for (Map.Entry entry : FIELD_BY_PRECISION.entrySet()) {
            DateRangePrecision precision = (DateRangePrecision)((Object)entry.getKey());
            int field = (Integer)entry.getValue();
            if (!calendar.isSet(field)) break;
            lastPrecision = precision;
        }
        return lastPrecision;
    }

    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        int year = calendar.get(1);
        if (calendar.get(0) == 0 && --year > 0) {
            year = -year;
        }
        LocalDateTime localDateTime = LocalDateTime.of(year, calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        localDateTime = localDateTime.with(ChronoField.MILLI_OF_SECOND, calendar.get(14));
        return ZonedDateTime.of(localDateTime, ZoneOffset.UTC);
    }
}

