/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.schema.AlterDseTableAddColumnEnd;
import com.datastax.dse.driver.api.querybuilder.schema.AlterDseTableDropColumnEnd;
import com.datastax.dse.driver.api.querybuilder.schema.AlterDseTableRenameColumnEnd;
import com.datastax.dse.driver.api.querybuilder.schema.AlterDseTableStart;
import com.datastax.dse.driver.api.querybuilder.schema.AlterDseTableWithOptionsEnd;
import com.datastax.dse.driver.api.querybuilder.schema.DseGraphEdgeSide;
import com.datastax.dse.driver.internal.querybuilder.schema.DseTableEdgeOperation;
import com.datastax.dse.driver.internal.querybuilder.schema.DseTableGraphOperationType;
import com.datastax.dse.driver.internal.querybuilder.schema.DseTableVertexOperation;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.internal.querybuilder.schema.Utils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultAlterDseTable
implements AlterDseTableStart,
AlterDseTableAddColumnEnd,
AlterDseTableDropColumnEnd,
AlterDseTableRenameColumnEnd,
AlterDseTableWithOptionsEnd,
BuildableQuery {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier tableName;
    private final ImmutableMap<CqlIdentifier, DataType> columnsToAddInOrder;
    private final ImmutableSet<CqlIdentifier> columnsToAdd;
    private final ImmutableSet<CqlIdentifier> columnsToAddStatic;
    private final ImmutableSet<CqlIdentifier> columnsToDrop;
    private final ImmutableMap<CqlIdentifier, CqlIdentifier> columnsToRename;
    private final CqlIdentifier columnToAlter;
    private final DataType columnToAlterType;
    private final DseTableVertexOperation vertexOperation;
    private final DseTableEdgeOperation edgeOperation;
    private final ImmutableMap<String, Object> options;
    private final boolean dropCompactStorage;

    public DefaultAlterDseTable(@NonNull CqlIdentifier tableName) {
        this(null, tableName);
    }

    public DefaultAlterDseTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        this(keyspace, tableName, false, ImmutableMap.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableMap.of(), null, null, null, null, ImmutableMap.of());
    }

    public DefaultAlterDseTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName, boolean dropCompactStorage, @NonNull ImmutableMap<CqlIdentifier, DataType> columnsToAddInOrder, @NonNull ImmutableSet<CqlIdentifier> columnsToAdd, @NonNull ImmutableSet<CqlIdentifier> columnsToAddStatic, @NonNull ImmutableSet<CqlIdentifier> columnsToDrop, @NonNull ImmutableMap<CqlIdentifier, CqlIdentifier> columnsToRename, @Nullable CqlIdentifier columnToAlter, @Nullable DataType columnToAlterType, @Nullable DseTableVertexOperation vertexOperation, @Nullable DseTableEdgeOperation edgeOperation, @NonNull ImmutableMap<String, Object> options) {
        this.keyspace = keyspace;
        this.tableName = tableName;
        this.dropCompactStorage = dropCompactStorage;
        this.columnsToAddInOrder = columnsToAddInOrder;
        this.columnsToAdd = columnsToAdd;
        this.columnsToAddStatic = columnsToAddStatic;
        this.columnsToDrop = columnsToDrop;
        this.columnsToRename = columnsToRename;
        this.columnToAlter = columnToAlter;
        this.columnToAlterType = columnToAlterType;
        this.vertexOperation = vertexOperation;
        this.edgeOperation = edgeOperation;
        this.options = options;
    }

    @Override
    @NonNull
    public AlterDseTableAddColumnEnd addColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, ImmutableCollections.append(this.columnsToAddInOrder, columnName, dataType), Utils.appendSet(this.columnsToAdd, columnName), this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public AlterDseTableAddColumnEnd addStaticColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, ImmutableCollections.append(this.columnsToAddInOrder, columnName, dataType), this.columnsToAdd, Utils.appendSet(this.columnsToAddStatic, columnName), this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public BuildableQuery dropCompactStorage() {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, true, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public AlterDseTableDropColumnEnd dropColumns(CqlIdentifier ... columnNames) {
        ImmutableCollection.Builder builder = ImmutableSet.builder().addAll(this.columnsToDrop);
        for (CqlIdentifier columnName : columnNames) {
            builder = ((ImmutableSet.Builder)builder).add(columnName);
        }
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, (ImmutableSet<CqlIdentifier>)((ImmutableSet.Builder)builder).build(), this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public AlterDseTableRenameColumnEnd renameColumn(@NonNull CqlIdentifier from, @NonNull CqlIdentifier to) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, ImmutableCollections.append(this.columnsToRename, from, to), this.columnToAlter, this.columnToAlterType, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public BuildableQuery alterColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, columnName, dataType, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public BuildableQuery withVertexLabel(@Nullable CqlIdentifier vertexLabelId) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, new DseTableVertexOperation(DseTableGraphOperationType.WITH, vertexLabelId), this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public BuildableQuery withoutVertexLabel(@Nullable CqlIdentifier vertexLabelId) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, new DseTableVertexOperation(DseTableGraphOperationType.WITHOUT, vertexLabelId), this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public BuildableQuery withEdgeLabel(@Nullable CqlIdentifier edgeLabelId, @NonNull DseGraphEdgeSide from, @NonNull DseGraphEdgeSide to) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.vertexOperation, new DseTableEdgeOperation(DseTableGraphOperationType.WITH, edgeLabelId, from, to), this.options);
    }

    @Override
    @NonNull
    public BuildableQuery withoutEdgeLabel(@Nullable CqlIdentifier edgeLabelId) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.vertexOperation, new DseTableEdgeOperation(DseTableGraphOperationType.WITHOUT, edgeLabelId, null, null), this.options);
    }

    @Override
    @NonNull
    public AlterDseTableWithOptionsEnd withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultAlterDseTable(this.keyspace, this.tableName, this.dropCompactStorage, this.columnsToAddInOrder, this.columnsToAdd, this.columnsToAddStatic, this.columnsToDrop, this.columnsToRename, this.columnToAlter, this.columnToAlterType, this.vertexOperation, this.edgeOperation, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        CqlHelper.qualify(this.keyspace, this.tableName, builder);
        if (this.columnToAlter != null) {
            return builder.append(" ALTER ").append(this.columnToAlter.asCql(true)).append(" TYPE ").append(this.columnToAlterType.asCql(true, true)).toString();
        }
        if (!this.columnsToAdd.isEmpty()) {
            builder.append(" ADD ");
            if (this.columnsToAdd.size() > 1) {
                builder.append('(');
            }
            boolean first = true;
            for (Map.Entry column : this.columnsToAddInOrder.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(((CqlIdentifier)column.getKey()).asCql(true)).append(' ').append(((DataType)column.getValue()).asCql(true, true));
                if (!this.columnsToAddStatic.contains(column.getKey())) continue;
                builder.append(" STATIC");
            }
            if (this.columnsToAdd.size() > 1) {
                builder.append(')');
            }
            return builder.toString();
        }
        if (!this.columnsToDrop.isEmpty()) {
            boolean moreThanOneDrop = this.columnsToDrop.size() > 1;
            CqlHelper.appendIds(this.columnsToDrop, builder, moreThanOneDrop ? " DROP (" : " DROP ", ",", moreThanOneDrop ? ")" : "");
            return builder.toString();
        }
        if (!this.columnsToRename.isEmpty()) {
            builder.append(" RENAME ");
            boolean first = true;
            for (Map.Entry entry : this.columnsToRename.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" AND ");
                }
                builder.append(((CqlIdentifier)entry.getKey()).asCql(true)).append(" TO ").append(((CqlIdentifier)entry.getValue()).asCql(true));
            }
            return builder.toString();
        }
        if (this.vertexOperation != null) {
            builder.append(' ').append((Object)this.vertexOperation.getType()).append(' ');
            this.vertexOperation.append(builder);
        } else if (this.edgeOperation != null) {
            builder.append(' ').append((Object)this.edgeOperation.getType()).append(' ');
            this.edgeOperation.append(builder);
        } else {
            if (this.dropCompactStorage) {
                return builder.append(" DROP COMPACT STORAGE").toString();
            }
            if (!this.options.isEmpty()) {
                return builder.append(OptionsUtils.buildOptions(this.options, true)).toString();
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.tableName;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, DataType> getColumnsToAddInOrder() {
        return this.columnsToAddInOrder;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getColumnsToAddRegular() {
        return this.columnsToAdd;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getColumnsToAddStatic() {
        return this.columnsToAddStatic;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getColumnsToDrop() {
        return this.columnsToDrop;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, CqlIdentifier> getColumnsToRename() {
        return this.columnsToRename;
    }

    @Nullable
    public CqlIdentifier getColumnToAlter() {
        return this.columnToAlter;
    }

    @Nullable
    public DataType getColumnToAlterType() {
        return this.columnToAlterType;
    }

    @Nullable
    public DseTableVertexOperation getVertexOperation() {
        return this.vertexOperation;
    }

    @Nullable
    public DseTableEdgeOperation getEdgeOperation() {
        return this.edgeOperation;
    }

    public boolean isDropCompactStorage() {
        return this.dropCompactStorage;
    }
}

