/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandler;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CqlRequestAsyncProcessor
implements RequestProcessor<Statement<?>, CompletionStage<AsyncResultSet>> {
    @Override
    public boolean canProcess(Request request, GenericType<?> resultType) {
        return request instanceof Statement && resultType.equals(Statement.ASYNC);
    }

    @Override
    public CompletionStage<AsyncResultSet> process(Statement<?> request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        return new CqlRequestHandler(request, session, context, sessionLogPrefix).handle();
    }

    @Override
    public CompletionStage<AsyncResultSet> newFailure(RuntimeException error) {
        return CompletableFutures.failedFuture(error);
    }
}

