/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.connection.CrcMismatchException;
import com.datastax.oss.protocol.internal.Segment;
import com.datastax.oss.protocol.internal.SegmentCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.nio.ByteOrder;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class BytesToSegmentDecoder
extends LengthFieldBasedFrameDecoder {
    private final SegmentCodec<ByteBuf> segmentCodec;
    private SegmentCodec.Header header;

    public BytesToSegmentDecoder(@NonNull SegmentCodec<ByteBuf> segmentCodec) {
        super(segmentCodec.headerLength() + 3 + Segment.MAX_PAYLOAD_LENGTH + 4, 0, segmentCodec.headerLength() + 3, 4, segmentCodec.headerLength() + 3);
        this.segmentCodec = segmentCodec;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        try {
            ByteBuf payloadAndCrc = (ByteBuf)super.decode(ctx, in);
            if (payloadAndCrc == null) {
                return null;
            }
            assert (this.header != null);
            try {
                Segment<ByteBuf> segment = this.segmentCodec.decode(this.header, payloadAndCrc);
                this.header = null;
                return segment;
            }
            catch (com.datastax.oss.protocol.internal.CrcMismatchException e) {
                throw new CrcMismatchException(e.getMessage());
            }
        }
        catch (Exception e) {
            this.header = null;
            throw e;
        }
    }

    @Override
    protected long getUnadjustedFrameLength(ByteBuf buffer, int offset, int length, ByteOrder order) {
        if (this.header == null) {
            try {
                this.header = this.segmentCodec.decodeHeader(buffer.slice(offset, length));
            }
            catch (com.datastax.oss.protocol.internal.CrcMismatchException e) {
                throw new CrcMismatchException(e.getMessage());
            }
        }
        return this.header.payloadLength;
    }
}

