/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.schema.AlterKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.AlterKeyspaceStart;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultAlterKeyspace
implements AlterKeyspaceStart,
AlterKeyspace {
    private final CqlIdentifier keyspaceName;
    private final ImmutableMap<String, Object> options;

    public DefaultAlterKeyspace(@NonNull CqlIdentifier keyspaceName) {
        this(keyspaceName, ImmutableMap.of());
    }

    public DefaultAlterKeyspace(@NonNull CqlIdentifier keyspaceName, @NonNull ImmutableMap<String, Object> options) {
        this.keyspaceName = keyspaceName;
        this.options = options;
    }

    @Override
    @NonNull
    public AlterKeyspace withReplicationOptions(@NonNull Map<String, Object> replicationOptions) {
        return this.withOption("replication", replicationOptions);
    }

    @Override
    @NonNull
    public AlterKeyspace withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultAlterKeyspace(this.keyspaceName, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        return "ALTER KEYSPACE " + this.keyspaceName.asCql(true) + OptionsUtils.buildOptions(this.options, true);
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspaceName;
    }

    public String toString() {
        return this.asCql();
    }
}

