/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionEnd;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionWithLanguage;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionWithNullOption;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionWithType;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateFunction
implements CreateFunctionStart,
CreateFunctionWithNullOption,
CreateFunctionWithType,
CreateFunctionWithLanguage,
CreateFunctionEnd {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier functionName;
    private boolean orReplace;
    private boolean ifNotExists;
    private final ImmutableMap<CqlIdentifier, DataType> parameters;
    private boolean returnsNullOnNull;
    private final DataType returnType;
    private final String language;
    private final String functionBody;

    public DefaultCreateFunction(@NonNull CqlIdentifier functionName) {
        this(null, functionName);
    }

    public DefaultCreateFunction(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName) {
        this(keyspace, functionName, false, false, ImmutableMap.of(), false, null, null, null);
    }

    public DefaultCreateFunction(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName, boolean orReplace, boolean ifNotExists, @NonNull ImmutableMap<CqlIdentifier, DataType> parameters, boolean returnsNullOnNull, @Nullable DataType returns, @Nullable String language, @Nullable String functionBody) {
        this.keyspace = keyspace;
        this.functionName = functionName;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
        this.parameters = parameters;
        this.returnsNullOnNull = returnsNullOnNull;
        this.returnType = returns;
        this.language = language;
        this.functionBody = functionBody;
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE ");
        if (this.orReplace) {
            builder.append("OR REPLACE ");
        }
        builder.append("FUNCTION ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.functionName, builder);
        builder.append(" (");
        boolean first = true;
        for (Map.Entry param : this.parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(((CqlIdentifier)param.getKey()).asCql(true)).append(' ').append(((DataType)param.getValue()).asCql(false, true));
        }
        builder.append(')');
        if (this.returnsNullOnNull) {
            builder.append(" RETURNS NULL");
        } else {
            builder.append(" CALLED");
        }
        builder.append(" ON NULL INPUT");
        if (this.returnType == null) {
            return builder.toString();
        }
        builder.append(" RETURNS ");
        builder.append(this.returnType.asCql(false, true));
        if (this.language == null) {
            return builder.toString();
        }
        builder.append(" LANGUAGE ");
        builder.append(this.language);
        if (this.functionBody == null) {
            return builder.toString();
        }
        builder.append(" AS ");
        builder.append(this.functionBody);
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public CreateFunctionEnd as(@NonNull String functionBody) {
        return new DefaultCreateFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, this.language, functionBody);
    }

    @Override
    @NonNull
    public CreateFunctionWithLanguage withLanguage(@NonNull String language) {
        return new DefaultCreateFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, language, this.functionBody);
    }

    @Override
    @NonNull
    public CreateFunctionWithType returnsType(@NonNull DataType returnType) {
        return new DefaultCreateFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.returnsNullOnNull, returnType, this.language, this.functionBody);
    }

    @Override
    @NonNull
    public CreateFunctionStart ifNotExists() {
        return new DefaultCreateFunction(this.keyspace, this.functionName, this.orReplace, true, this.parameters, this.returnsNullOnNull, this.returnType, this.language, this.functionBody);
    }

    @Override
    @NonNull
    public CreateFunctionStart orReplace() {
        return new DefaultCreateFunction(this.keyspace, this.functionName, true, this.ifNotExists, this.parameters, this.returnsNullOnNull, this.returnType, this.language, this.functionBody);
    }

    @Override
    @NonNull
    public CreateFunctionStart withParameter(@NonNull CqlIdentifier paramName, @NonNull DataType paramType) {
        return new DefaultCreateFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, ImmutableCollections.append(this.parameters, paramName, paramType), this.returnsNullOnNull, this.returnType, this.language, this.functionBody);
    }

    @Override
    @NonNull
    public CreateFunctionWithNullOption returnsNullOnNull() {
        return new DefaultCreateFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, true, this.returnType, this.language, this.functionBody);
    }

    @Override
    @NonNull
    public CreateFunctionWithNullOption calledOnNull() {
        return new DefaultCreateFunction(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, false, this.returnType, this.language, this.functionBody);
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getFunction() {
        return this.functionName;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, DataType> getParameters() {
        return this.parameters;
    }

    public boolean isReturnsNullOnNull() {
        return this.returnsNullOnNull;
    }

    @Nullable
    public DataType getReturnType() {
        return this.returnType;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public String getFunctionBody() {
        return this.functionBody;
    }
}

