/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import org.apache.camel.CamelContext;
import org.apache.camel.processor.aggregate.cassandra.CassandraAggregationRepository;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class CassandraAggregationRepositoryConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CassandraAggregationRepository target = (CassandraAggregationRepository)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                target.setAllowSerializedHeaders(CassandraAggregationRepositoryConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "deadletteruri": 
            case "deadLetterUri": {
                target.setDeadLetterUri(CassandraAggregationRepositoryConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "exchangecolumn": 
            case "exchangeColumn": {
                target.setExchangeColumn(CassandraAggregationRepositoryConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "exchangeidcolumn": 
            case "exchangeIdColumn": {
                target.setExchangeIdColumn(CassandraAggregationRepositoryConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "maximumredeliveries": 
            case "maximumRedeliveries": {
                target.setMaximumRedeliveries(CassandraAggregationRepositoryConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "pkcolumns": 
            case "pKColumns": {
                target.setPKColumns(CassandraAggregationRepositoryConfigurer.property(camelContext, String[].class, value));
                return true;
            }
            case "prefixpkvalues": 
            case "prefixPKValues": {
                target.setPrefixPKValues(CassandraAggregationRepositoryConfigurer.property(camelContext, Object[].class, value));
                return true;
            }
            case "readconsistencylevel": 
            case "readConsistencyLevel": {
                target.setReadConsistencyLevel(CassandraAggregationRepositoryConfigurer.property(camelContext, ConsistencyLevel.class, value));
                return true;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                target.setRecoveryInterval(CassandraAggregationRepositoryConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "session": {
                target.setSession(CassandraAggregationRepositoryConfigurer.property(camelContext, CqlSession.class, value));
                return true;
            }
            case "table": {
                target.setTable(CassandraAggregationRepositoryConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ttl": {
                target.setTtl(CassandraAggregationRepositoryConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "userecovery": 
            case "useRecovery": {
                target.setUseRecovery(CassandraAggregationRepositoryConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "writeconsistencylevel": 
            case "writeConsistencyLevel": {
                target.setWriteConsistencyLevel(CassandraAggregationRepositoryConfigurer.property(camelContext, ConsistencyLevel.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return Boolean.TYPE;
            }
            case "deadletteruri": 
            case "deadLetterUri": {
                return String.class;
            }
            case "exchangecolumn": 
            case "exchangeColumn": {
                return String.class;
            }
            case "exchangeidcolumn": 
            case "exchangeIdColumn": {
                return String.class;
            }
            case "maximumredeliveries": 
            case "maximumRedeliveries": {
                return Integer.TYPE;
            }
            case "pkcolumns": 
            case "pKColumns": {
                return String[].class;
            }
            case "prefixpkvalues": 
            case "prefixPKValues": {
                return Object[].class;
            }
            case "readconsistencylevel": 
            case "readConsistencyLevel": {
                return ConsistencyLevel.class;
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return Long.TYPE;
            }
            case "session": {
                return CqlSession.class;
            }
            case "table": {
                return String.class;
            }
            case "ttl": {
                return Integer.class;
            }
            case "userecovery": 
            case "useRecovery": {
                return Boolean.TYPE;
            }
            case "writeconsistencylevel": 
            case "writeConsistencyLevel": {
                return ConsistencyLevel.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CassandraAggregationRepository target = (CassandraAggregationRepository)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowserializedheaders": 
            case "allowSerializedHeaders": {
                return target.isAllowSerializedHeaders();
            }
            case "deadletteruri": 
            case "deadLetterUri": {
                return target.getDeadLetterUri();
            }
            case "exchangecolumn": 
            case "exchangeColumn": {
                return target.getExchangeColumn();
            }
            case "exchangeidcolumn": 
            case "exchangeIdColumn": {
                return target.getExchangeIdColumn();
            }
            case "maximumredeliveries": 
            case "maximumRedeliveries": {
                return target.getMaximumRedeliveries();
            }
            case "pkcolumns": 
            case "pKColumns": {
                return target.getPKColumns();
            }
            case "prefixpkvalues": 
            case "prefixPKValues": {
                return target.getPrefixPKValues();
            }
            case "readconsistencylevel": 
            case "readConsistencyLevel": {
                return target.getReadConsistencyLevel();
            }
            case "recoveryinterval": 
            case "recoveryInterval": {
                return target.getRecoveryInterval();
            }
            case "session": {
                return target.getSession();
            }
            case "table": {
                return target.getTable();
            }
            case "ttl": {
                return target.getTtl();
            }
            case "userecovery": 
            case "useRecovery": {
                return target.isUseRecovery();
            }
            case "writeconsistencylevel": 
            case "writeConsistencyLevel": {
                return target.getWriteConsistencyLevel();
            }
        }
        return null;
    }
}

