/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.condition;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.condition.ConditionBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.condition.DefaultConditionBuilder;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnComponentLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.lhs.FieldLeftOperand;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;

public interface ConditionalStatement<SelfT extends ConditionalStatement<SelfT>> {
    @NonNull
    @CheckReturnValue
    public SelfT ifExists();

    @NonNull
    @CheckReturnValue
    public SelfT if_(@NonNull Condition var1);

    @NonNull
    @CheckReturnValue
    public SelfT if_(@NonNull Iterable<Condition> var1);

    @NonNull
    @CheckReturnValue
    default public SelfT if_(Condition ... conditions) {
        return this.if_(Arrays.asList(conditions));
    }

    @NonNull
    default public ConditionBuilder<SelfT> ifColumn(@NonNull CqlIdentifier columnId) {
        return new DefaultConditionBuilder.Fluent(this, new ColumnLeftOperand(columnId));
    }

    @NonNull
    default public ConditionBuilder<SelfT> ifColumn(@NonNull String columnName) {
        return this.ifColumn(CqlIdentifier.fromCql(columnName));
    }

    @NonNull
    default public ConditionBuilder<SelfT> ifField(@NonNull CqlIdentifier columnId, @NonNull CqlIdentifier fieldId) {
        return new DefaultConditionBuilder.Fluent(this, new FieldLeftOperand(columnId, fieldId));
    }

    @NonNull
    default public ConditionBuilder<SelfT> ifField(@NonNull String columnName, @NonNull String fieldName) {
        return this.ifField(CqlIdentifier.fromCql(columnName), CqlIdentifier.fromCql(fieldName));
    }

    @NonNull
    default public ConditionBuilder<SelfT> ifElement(@NonNull CqlIdentifier columnId, @NonNull Term index) {
        return new DefaultConditionBuilder.Fluent(this, new ColumnComponentLeftOperand(columnId, index));
    }

    @NonNull
    default public ConditionBuilder<SelfT> ifElement(@NonNull String columnName, @NonNull Term index) {
        return this.ifElement(CqlIdentifier.fromCql(columnName), index);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT ifRaw(@NonNull String raw) {
        return this.if_((Condition)QueryBuilder.raw(raw));
    }
}

