/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.time;

import com.datastax.dse.driver.api.core.data.time.DateRangeBound;
import com.datastax.dse.driver.api.core.data.time.DateRangePrecision;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

public class DateRange
implements Serializable {
    @NonNull
    private final DateRangeBound lowerBound;
    @Nullable
    private final DateRangeBound upperBound;

    @NonNull
    public static DateRange parse(@NonNull String source) throws ParseException {
        if (Strings.isNullOrEmpty(source)) {
            throw new ParseException("Date range is null or empty", 0);
        }
        if (source.charAt(0) == '[') {
            DateRangeBound upperBound;
            DateRangeBound lowerBound;
            if (source.charAt(source.length() - 1) != ']') {
                throw new ParseException("If date range starts with '[' it must end with ']'; got " + source, source.length() - 1);
            }
            int middle = source.indexOf(" TO ");
            if (middle < 0) {
                throw new ParseException("If date range starts with '[' it must contain ' TO '; got " + source, 0);
            }
            String lowerBoundString = source.substring(1, middle);
            int upperBoundStart = middle + 4;
            String upperBoundString = source.substring(upperBoundStart, source.length() - 1);
            try {
                lowerBound = DateRangeBound.parseLowerBound(lowerBoundString);
            }
            catch (Exception e) {
                throw DateRange.newParseException("Cannot parse date range lower bound: " + source, 1, e);
            }
            try {
                upperBound = DateRangeBound.parseUpperBound(upperBoundString);
            }
            catch (Exception e) {
                throw DateRange.newParseException("Cannot parse date range upper bound: " + source, upperBoundStart, e);
            }
            return new DateRange(lowerBound, upperBound);
        }
        try {
            return new DateRange(DateRangeBound.parseLowerBound(source));
        }
        catch (Exception e) {
            throw DateRange.newParseException("Cannot parse single date range bound: " + source, 0, e);
        }
    }

    public DateRange(@NonNull DateRangeBound singleBound) {
        this.lowerBound = Preconditions.checkNotNull(singleBound, "singleBound cannot be null");
        this.upperBound = null;
    }

    public DateRange(@NonNull DateRangeBound lowerBound, @NonNull DateRangeBound upperBound) {
        Preconditions.checkNotNull(lowerBound, "lowerBound cannot be null");
        Preconditions.checkNotNull(upperBound, "upperBound cannot be null");
        if (!lowerBound.isUnbounded() && !upperBound.isUnbounded() && lowerBound.getTimestamp().compareTo(upperBound.getTimestamp()) >= 0) {
            throw new IllegalArgumentException(String.format("Lower bound of a date range should be before upper bound, got: [%s TO %s]", lowerBound, upperBound));
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @NonNull
    public DateRangeBound getLowerBound() {
        return this.lowerBound;
    }

    @NonNull
    public Optional<DateRangeBound> getUpperBound() {
        return Optional.ofNullable(this.upperBound);
    }

    public boolean isSingleBounded() {
        return this.upperBound == null;
    }

    @NonNull
    public String toString() {
        if (this.isSingleBounded()) {
            return this.lowerBound.toString();
        }
        return String.format("[%s TO %s]", this.lowerBound, this.upperBound);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DateRange) {
            DateRange that = (DateRange)other;
            return Objects.equals(this.lowerBound, that.lowerBound) && Objects.equals(this.upperBound, that.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    private static ParseException newParseException(String message, int offset, Exception cause) {
        ParseException parseException = new ParseException(message, offset);
        parseException.initCause(cause);
        return parseException;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ZonedDateTime lowerBoundTimestamp;
        private final DateRangePrecision lowerBoundPrecision;
        private final ZonedDateTime upperBoundTimestamp;
        private final DateRangePrecision upperBoundPrecision;

        SerializationProxy(DateRange input) {
            this.lowerBoundTimestamp = input.lowerBound.getTimestamp();
            this.lowerBoundPrecision = input.lowerBound.getPrecision();
            if (input.upperBound != null) {
                this.upperBoundTimestamp = input.upperBound.getTimestamp();
                this.upperBoundPrecision = input.upperBound.getPrecision();
            } else {
                this.upperBoundTimestamp = null;
                this.upperBoundPrecision = null;
            }
        }

        private Object readResolve() {
            if (this.upperBoundTimestamp == null ^ this.upperBoundPrecision == null) {
                throw new IllegalArgumentException("Invalid serialized form, upper bound timestamp and precision should be either both null or both non-null");
            }
            if (this.upperBoundTimestamp == null) {
                return new DateRange(DateRangeBound.lowerBound(this.lowerBoundTimestamp, this.lowerBoundPrecision));
            }
            return new DateRange(DateRangeBound.lowerBound(this.lowerBoundTimestamp, this.lowerBoundPrecision), DateRangeBound.upperBound(this.upperBoundTimestamp, this.upperBoundPrecision));
        }
    }
}

