/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.schema.CreateDseKeyspace;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseKeyspaceStart;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateDseKeyspace
implements CreateDseKeyspace,
CreateDseKeyspaceStart {
    private final CqlIdentifier keyspaceName;
    private final boolean ifNotExists;
    private final ImmutableMap<String, Object> options;

    public DefaultCreateDseKeyspace(@NonNull CqlIdentifier keyspaceName) {
        this(keyspaceName, false, ImmutableMap.of());
    }

    public DefaultCreateDseKeyspace(@NonNull CqlIdentifier keyspaceName, boolean ifNotExists, @NonNull ImmutableMap<String, Object> options) {
        this.keyspaceName = keyspaceName;
        this.ifNotExists = ifNotExists;
        this.options = options;
    }

    @Override
    @NonNull
    public CreateDseKeyspace withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultCreateDseKeyspace(this.keyspaceName, this.ifNotExists, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public CreateDseKeyspaceStart ifNotExists() {
        return new DefaultCreateDseKeyspace(this.keyspaceName, true, this.options);
    }

    @Override
    @NonNull
    public CreateDseKeyspace withReplicationOptions(@NonNull Map<String, Object> replicationOptions) {
        return this.withOption("replication", replicationOptions);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE KEYSPACE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(this.keyspaceName.asCql(true));
        builder.append(OptionsUtils.buildOptions(this.options, true));
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspaceName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }
}

