/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.schema.CreateDseTable;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseTableStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseTableWithOptions;
import com.datastax.dse.driver.api.querybuilder.schema.DseGraphEdgeSide;
import com.datastax.dse.driver.internal.querybuilder.schema.DseTableEdgeOperation;
import com.datastax.dse.driver.internal.querybuilder.schema.DseTableGraphOperationType;
import com.datastax.dse.driver.internal.querybuilder.schema.DseTableVertexOperation;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.internal.querybuilder.schema.Utils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateDseTable
implements CreateDseTableStart,
CreateDseTable,
CreateDseTableWithOptions {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier tableName;
    private final boolean ifNotExists;
    private final boolean compactStorage;
    private final ImmutableMap<String, Object> options;
    private final ImmutableMap<CqlIdentifier, DataType> columnsInOrder;
    private final ImmutableSet<CqlIdentifier> partitionKeyColumns;
    private final ImmutableSet<CqlIdentifier> clusteringKeyColumns;
    private final ImmutableSet<CqlIdentifier> staticColumns;
    private final ImmutableSet<CqlIdentifier> regularColumns;
    private final ImmutableMap<CqlIdentifier, ClusteringOrder> orderings;
    private final DseTableVertexOperation vertexOperation;
    private final DseTableEdgeOperation edgeOperation;

    public DefaultCreateDseTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        this(keyspace, tableName, false, false, ImmutableMap.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableSet.of(), ImmutableMap.of(), null, null, ImmutableMap.of());
    }

    public DefaultCreateDseTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName, boolean ifNotExists, boolean compactStorage, @NonNull ImmutableMap<CqlIdentifier, DataType> columnsInOrder, @NonNull ImmutableSet<CqlIdentifier> partitionKeyColumns, @NonNull ImmutableSet<CqlIdentifier> clusteringKeyColumns, @NonNull ImmutableSet<CqlIdentifier> staticColumns, @NonNull ImmutableSet<CqlIdentifier> regularColumns, @NonNull ImmutableMap<CqlIdentifier, ClusteringOrder> orderings, @Nullable DseTableVertexOperation vertexOperation, @Nullable DseTableEdgeOperation edgeOperation, @NonNull ImmutableMap<String, Object> options) {
        this.keyspace = keyspace;
        this.tableName = tableName;
        this.ifNotExists = ifNotExists;
        this.compactStorage = compactStorage;
        this.columnsInOrder = columnsInOrder;
        this.partitionKeyColumns = partitionKeyColumns;
        this.clusteringKeyColumns = clusteringKeyColumns;
        this.staticColumns = staticColumns;
        this.regularColumns = regularColumns;
        this.orderings = orderings;
        this.options = options;
        this.vertexOperation = vertexOperation;
        this.edgeOperation = edgeOperation;
    }

    @Override
    @NonNull
    public CreateDseTableStart ifNotExists() {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, true, this.compactStorage, this.columnsInOrder, this.partitionKeyColumns, this.clusteringKeyColumns, this.staticColumns, this.regularColumns, this.orderings, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTable withPartitionKey(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, ImmutableCollections.append(this.columnsInOrder, columnName, dataType), Utils.appendSet(this.partitionKeyColumns, columnName), this.clusteringKeyColumns, this.staticColumns, this.regularColumns, this.orderings, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTable withClusteringColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, ImmutableCollections.append(this.columnsInOrder, columnName, dataType), this.partitionKeyColumns, Utils.appendSet(this.clusteringKeyColumns, columnName), this.staticColumns, this.regularColumns, this.orderings, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTable withColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, ImmutableCollections.append(this.columnsInOrder, columnName, dataType), this.partitionKeyColumns, this.clusteringKeyColumns, this.staticColumns, Utils.appendSet(this.regularColumns, columnName), this.orderings, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTable withStaticColumn(@NonNull CqlIdentifier columnName, @NonNull DataType dataType) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, ImmutableCollections.append(this.columnsInOrder, columnName, dataType), this.partitionKeyColumns, this.clusteringKeyColumns, Utils.appendSet(this.staticColumns, columnName), this.regularColumns, this.orderings, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTableWithOptions withCompactStorage() {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, true, this.columnsInOrder, this.partitionKeyColumns, this.clusteringKeyColumns, this.staticColumns, this.regularColumns, this.orderings, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTableWithOptions withClusteringOrderByIds(@NonNull Map<CqlIdentifier, ClusteringOrder> orderings) {
        return this.withClusteringOrders(ImmutableCollections.concat(this.orderings, orderings));
    }

    @Override
    @NonNull
    public CreateDseTableWithOptions withClusteringOrder(@NonNull CqlIdentifier columnName, @NonNull ClusteringOrder order) {
        return this.withClusteringOrders(ImmutableCollections.append(this.orderings, columnName, order));
    }

    @NonNull
    public CreateDseTableWithOptions withClusteringOrders(@NonNull ImmutableMap<CqlIdentifier, ClusteringOrder> orderings) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, this.columnsInOrder, this.partitionKeyColumns, this.clusteringKeyColumns, this.staticColumns, this.regularColumns, orderings, this.vertexOperation, this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTableWithOptions withVertexLabel(@Nullable CqlIdentifier vertexLabelId) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, this.columnsInOrder, this.partitionKeyColumns, this.clusteringKeyColumns, this.staticColumns, this.regularColumns, this.orderings, new DseTableVertexOperation(DseTableGraphOperationType.WITH, vertexLabelId), this.edgeOperation, this.options);
    }

    @Override
    @NonNull
    public CreateDseTableWithOptions withEdgeLabel(@Nullable CqlIdentifier edgeLabelId, @NonNull DseGraphEdgeSide from, @NonNull DseGraphEdgeSide to) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, this.columnsInOrder, this.partitionKeyColumns, this.clusteringKeyColumns, this.staticColumns, this.regularColumns, this.orderings, this.vertexOperation, new DseTableEdgeOperation(DseTableGraphOperationType.WITH, edgeLabelId, from, to), this.options);
    }

    @Override
    @NonNull
    public CreateDseTable withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultCreateDseTable(this.keyspace, this.tableName, this.ifNotExists, this.compactStorage, this.columnsInOrder, this.partitionKeyColumns, this.clusteringKeyColumns, this.staticColumns, this.regularColumns, this.orderings, this.vertexOperation, this.edgeOperation, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.tableName, builder);
        if (this.columnsInOrder.isEmpty()) {
            return builder.toString();
        }
        boolean singlePrimaryKey = this.partitionKeyColumns.size() == 1 && this.clusteringKeyColumns.size() == 0;
        builder.append(" (");
        boolean first = true;
        for (Map.Entry column : this.columnsInOrder.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(((CqlIdentifier)column.getKey()).asCql(true)).append(' ').append(((DataType)column.getValue()).asCql(true, true));
            if (singlePrimaryKey && this.partitionKeyColumns.contains(column.getKey())) {
                builder.append(" PRIMARY KEY");
                continue;
            }
            if (!this.staticColumns.contains(column.getKey())) continue;
            builder.append(" STATIC");
        }
        if (!singlePrimaryKey) {
            builder.append(",");
            CqlHelper.buildPrimaryKey(this.partitionKeyColumns, this.clusteringKeyColumns, builder);
        }
        builder.append(')');
        boolean firstOption = true;
        if (this.compactStorage) {
            firstOption = false;
            builder.append(" WITH COMPACT STORAGE");
        }
        if (!this.orderings.isEmpty()) {
            if (firstOption) {
                builder.append(" WITH ");
                firstOption = false;
            } else {
                builder.append(" AND ");
            }
            builder.append("CLUSTERING ORDER BY (");
            boolean firstClustering = true;
            for (Map.Entry ordering : this.orderings.entrySet()) {
                if (firstClustering) {
                    firstClustering = false;
                } else {
                    builder.append(',');
                }
                builder.append(((CqlIdentifier)ordering.getKey()).asCql(true)).append(' ').append(((ClusteringOrder)((Object)ordering.getValue())).toString());
            }
            builder.append(')');
        }
        if (this.vertexOperation != null) {
            if (firstOption) {
                builder.append(" WITH ");
                firstOption = false;
            } else {
                builder.append(" AND ");
            }
            this.vertexOperation.append(builder);
        } else if (this.edgeOperation != null) {
            if (firstOption) {
                builder.append(" WITH ");
                firstOption = false;
            } else {
                builder.append(" AND ");
            }
            this.edgeOperation.append(builder);
        }
        builder.append(OptionsUtils.buildOptions(this.options, firstOption));
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.tableName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isCompactStorage() {
        return this.compactStorage;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, DataType> getColumnsInOrder() {
        return this.columnsInOrder;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getPartitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getClusteringKeyColumns() {
        return this.clusteringKeyColumns;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getStaticColumns() {
        return this.staticColumns;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getRegularColumns() {
        return this.regularColumns;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, ClusteringOrder> getOrderings() {
        return this.orderings;
    }
}

