/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ColumnSelector
implements Selector {
    private final CqlIdentifier columnId;
    private final CqlIdentifier alias;

    public ColumnSelector(@NonNull CqlIdentifier columnId) {
        this(columnId, null);
    }

    public ColumnSelector(@NonNull CqlIdentifier columnId, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(columnId);
        this.columnId = columnId;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new ColumnSelector(this.columnId, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append(this.columnId.asCql(true));
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public CqlIdentifier getColumnId() {
        return this.columnId;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ColumnSelector) {
            ColumnSelector that = (ColumnSelector)other;
            return this.columnId.equals(that.columnId) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.columnId, this.alias);
    }
}

