/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class FieldSelector
implements Selector {
    private final Selector udt;
    private final CqlIdentifier fieldId;
    private final CqlIdentifier alias;

    public FieldSelector(@NonNull Selector udt, @NonNull CqlIdentifier fieldId) {
        this(udt, fieldId, null);
    }

    public FieldSelector(@NonNull Selector udt, @NonNull CqlIdentifier fieldId, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(udt);
        Preconditions.checkNotNull(fieldId);
        this.udt = udt;
        this.fieldId = fieldId;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new FieldSelector(this.udt, this.fieldId, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        this.udt.appendTo(builder);
        builder.append('.').append(this.fieldId.asCql(true));
        if (this.alias != null) {
            builder.append(" AS ").append(this.alias.asCql(true));
        }
    }

    @NonNull
    public Selector getUdt() {
        return this.udt;
    }

    @NonNull
    public CqlIdentifier getFieldId() {
        return this.fieldId;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof FieldSelector) {
            FieldSelector that = (FieldSelector)other;
            return this.udt.equals(that.udt) && this.fieldId.equals(that.fieldId) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.udt, this.fieldId, this.alias);
    }
}

