/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.update;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class CollectionAssignment
implements Assignment {
    private final CqlIdentifier columnId;
    private final Operator operator;
    private final Term value;

    protected CollectionAssignment(@NonNull CqlIdentifier columnId, @NonNull Operator operator, @NonNull Term value) {
        Preconditions.checkNotNull(columnId);
        Preconditions.checkNotNull(value);
        this.columnId = columnId;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        builder.append(String.format(this.operator.pattern, this.columnId.asCql(true), this.buildRightOperand()));
    }

    private String buildRightOperand() {
        StringBuilder builder = new StringBuilder();
        this.value.appendTo(builder);
        return builder.toString();
    }

    @Override
    public boolean isIdempotent() {
        return this.operator == Operator.REMOVE && this.value.isIdempotent();
    }

    @NonNull
    public CqlIdentifier getColumnId() {
        return this.columnId;
    }

    @NonNull
    public Term getValue() {
        return this.value;
    }

    public static enum Operator {
        APPEND("%1$s=%1$s+%2$s"),
        PREPEND("%1$s=%2$s+%1$s"),
        REMOVE("%1$s=%1$s-%2$s");

        public final String pattern;

        private Operator(String pattern) {
            this.pattern = pattern;
        }
    }
}

