/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.csvreader.CsvReader;
import com.x5.template.TemplateSet;
import com.x5.template.providers.TranslationsProvider;
import com.x5.util.JarResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTranslationsProvider
implements TranslationsProvider {
    private static Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();

    @Override
    public Map<String, String> getTranslations(String localeCode) {
        if (cache.containsKey(localeCode)) {
            return cache.get(localeCode);
        }
        Map<String, String> translations = this.loadTranslations(localeCode);
        cache.put(localeCode, translations);
        return translations;
    }

    private Map<String, String> loadTranslations(String localeCode) {
        HashMap<String, String> translations = new HashMap<String, String>();
        try {
            InputStream in = this.locateLocaleDB(localeCode);
            if (in == null) {
                return translations;
            }
            Charset charset = this.grokLocaleDBCharset();
            CsvReader reader = new CsvReader(in, charset);
            reader.setUseComments(true);
            while (reader.readRecord()) {
                String[] entry = reader.getValues();
                if (entry == null || entry.length <= 1 || entry[0] == null || entry[1] == null) continue;
                String key = entry[0];
                String localString = entry[1];
                translations.put(key, localString);
            }
        }
        catch (IOException e) {
            System.err.println("ERROR loading locale DB: " + localeCode);
            e.printStackTrace(System.err);
        }
        return translations;
    }

    private Charset grokLocaleDBCharset() {
        String override = System.getProperty("chunk.localedb.charset");
        if (override != null) {
            Charset charset = null;
            try {
                charset = Charset.forName(override);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
            if (charset != null) {
                return charset;
            }
        }
        try {
            return Charset.forName("UTF-8");
        }
        catch (Exception exception) {
            return Charset.defaultCharset();
        }
    }

    private InputStream locateLocaleDB(String localeCode) throws IOException {
        File file;
        File folder;
        String sysLocalePath = System.getProperty("chunk.localedb.path");
        if (sysLocalePath != null && (folder = new File(sysLocalePath)).exists() && (file = new File(folder, localeCode + "/translate.csv")).exists()) {
            return new FileInputStream(file);
        }
        String path = "/locale/" + localeCode + "/translate.csv";
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in != null) {
            return in;
        }
        Class<?> classInApp = TemplateSet.grokCallerClass();
        if (classInApp != null && (in = classInApp.getResourceAsStream(path)) != null) {
            return in;
        }
        String cp = System.getProperty("java.class.path");
        if (cp == null) {
            return null;
        }
        String[] jars = cp.split(":");
        if (jars == null) {
            return null;
        }
        for (String jar : jars) {
            if (!jar.endsWith(".jar") || (in = JarResource.peekInsideJar("jar:file:" + jar, path)) == null) continue;
            return in;
        }
        return null;
    }
}

