/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.component.cm.CMConfiguration;
import org.apache.camel.component.cm.CMEndpoint;
import org.apache.camel.component.cm.CMMessage;
import org.apache.camel.component.cm.CMSender;
import org.apache.camel.component.cm.client.SMSMessage;
import org.apache.camel.component.cm.exceptions.HostUnavailableException;
import org.apache.camel.support.DefaultProducer;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CMProducer.class);
    private Validator validator;
    private CMSender sender;
    private final HttpClient client;

    public CMProducer(CMEndpoint endpoint, CMSender sender) {
        super(endpoint);
        this.sender = sender;
        this.client = endpoint.getHttpClient();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        SMSMessage smsMessage = exchange.getIn().getMandatoryBody(SMSMessage.class);
        LOG.trace("Validating SMSMessage instance provided: {}", (Object)smsMessage);
        Set<ConstraintViolation<SMSMessage>> constraintViolations = this.getValidator().validate(smsMessage, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation<SMSMessage> cv : constraintViolations) {
                msg.append(String.format("- Invalid value for %s: %s", cv.getPropertyPath().toString(), cv.getMessage()));
            }
            LOG.debug("SMS message: {}", (Object)msg);
            throw new InvalidPayloadRuntimeException(exchange, SMSMessage.class);
        }
        LOG.trace("SMSMessage instance is valid: {}", (Object)smsMessage);
        CMMessage cmMessage = new CMMessage(smsMessage.getPhoneNumber(), smsMessage.getMessage());
        LOG.debug("CMMessage instance build from valid SMSMessage instance");
        if (smsMessage.getFrom() == null || smsMessage.getFrom().isEmpty()) {
            String df = this.getConfiguration().getDefaultFrom();
            cmMessage.setSender(df);
            LOG.debug("Dynamic sender is set to default dynamic sender: {}", (Object)df);
        }
        cmMessage.setIdAsString(smsMessage.getId());
        cmMessage.setUnicodeAndMultipart(this.getConfiguration().getDefaultMaxNumberOfParts());
        this.sender.send(cmMessage);
        LOG.debug("Request accepted by CM Host: {}", (Object)cmMessage);
    }

    @Override
    protected void doStart() throws Exception {
        LOG.debug("Starting CMProducer");
        CMConfiguration configuration = this.getConfiguration();
        if (configuration.isTestConnectionOnStartup()) {
            try {
                LOG.debug("Checking connection - {}", (Object)this.getEndpoint().getCMUrl());
                this.client.execute((ClassicHttpRequest)new HttpHead(this.getEndpoint().getCMUrl()), res -> null);
                LOG.debug("Connection to {}: OK", (Object)this.getEndpoint().getCMUrl());
            }
            catch (Exception e) {
                throw new HostUnavailableException(String.format("Connection to %s: NOT AVAILABLE", this.getEndpoint().getCMUrl()), e);
            }
        }
        super.doStart();
        LOG.debug("CMProducer started");
    }

    @Override
    public CMEndpoint getEndpoint() {
        return (CMEndpoint)super.getEndpoint();
    }

    public CMConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.validator = this.getEndpoint().getComponent().getValidator();
        }
        return this.validator;
    }

    public CMSender getSender() {
        return this.sender;
    }

    public void setSender(CMSender sender) {
        this.sender = sender;
    }
}

