/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedByteArrayOutputStream;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.util.IOHelper;

public class CachedOutputStream
extends OutputStream {
    private final StreamCachingStrategy strategy;
    private OutputStream currentStream;
    private boolean inMemory = true;
    private int totalLength;
    private final FileInputStreamCache.TempFileManager tempFileManager;
    private final boolean closedOnCompletion;

    public CachedOutputStream(Exchange exchange) {
        this(exchange, true);
    }

    public CachedOutputStream(Exchange exchange, boolean closedOnCompletion) {
        this.closedOnCompletion = closedOnCompletion;
        this.tempFileManager = new FileInputStreamCache.TempFileManager(closedOnCompletion);
        this.tempFileManager.addExchange(exchange);
        this.strategy = exchange.getContext().getStreamCachingStrategy();
        this.currentStream = new CachedByteArrayOutputStream(this.strategy.getBufferSize());
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.currentStream.close();
        if (!this.closedOnCompletion) {
            this.tempFileManager.closeFileInputStreams();
            this.tempFileManager.cleanUpTempFile();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof CachedOutputStream) {
            CachedOutputStream cos = (CachedOutputStream)obj;
            return this.currentStream.equals(cos.currentStream);
        }
        return this.currentStream.equals(obj);
    }

    public int hashCode() {
        return this.currentStream.hashCode();
    }

    public OutputStream getCurrentStream() {
        return this.currentStream;
    }

    public String toString() {
        return "CachedOutputStream[size: " + this.totalLength + "]";
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.totalLength += len;
        if (this.inMemory && this.currentStream instanceof ByteArrayOutputStream && this.strategy.shouldSpoolCache(this.totalLength)) {
            this.pageToFileStream();
        }
        this.currentStream.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.totalLength += b.length;
        if (this.inMemory && this.currentStream instanceof ByteArrayOutputStream && this.strategy.shouldSpoolCache(this.totalLength)) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        ++this.totalLength;
        if (this.inMemory && this.currentStream instanceof ByteArrayOutputStream && this.strategy.shouldSpoolCache(this.totalLength)) {
            this.pageToFileStream();
        }
        this.currentStream.write(b);
    }

    public InputStream getInputStream() throws IOException {
        return (InputStream)((Object)this.newStreamCache());
    }

    public InputStream getWrappedInputStream() throws IOException {
        return new WrappedInputStream(this, (InputStream)((Object)this.newStreamCache()));
    }

    public StreamCache newStreamCache() throws IOException {
        this.flush();
        if (this.inMemory) {
            OutputStream outputStream = this.currentStream;
            if (outputStream instanceof CachedByteArrayOutputStream) {
                CachedByteArrayOutputStream cachedByteArrayOutputStream = (CachedByteArrayOutputStream)outputStream;
                return cachedByteArrayOutputStream.newInputStreamCache();
            }
            throw new IllegalStateException("CurrentStream should be an instance of CachedByteArrayOutputStream but is: " + this.currentStream.getClass().getName());
        }
        return this.tempFileManager.newStreamCache();
    }

    private void pageToFileStream() throws IOException {
        this.flush();
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        try {
            this.currentStream = this.tempFileManager.createOutputStream(this.strategy);
            bout.writeTo(this.currentStream);
        }
        finally {
            this.inMemory = false;
        }
    }

    public int getStrategyBufferSize() {
        return this.strategy.getBufferSize();
    }

    private static class WrappedInputStream
    extends InputStream
    implements StreamCache {
        private final Lock lock = new ReentrantLock();
        private final CachedOutputStream cachedOutputStream;
        private final InputStream inputStream;
        private long pos;

        WrappedInputStream(CachedOutputStream cos, InputStream is) {
            this.cachedOutputStream = cos;
            this.inputStream = is;
        }

        @Override
        public int read() throws IOException {
            ++this.pos;
            return this.inputStream.read();
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void reset() {
            this.lock.lock();
            try {
                this.inputStream.reset();
            }
            catch (IOException iOException) {
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void writeTo(OutputStream os) throws IOException {
            IOHelper.copy(this, os);
        }

        @Override
        public StreamCache copy(Exchange exchange) throws IOException {
            return this.cachedOutputStream.newStreamCache();
        }

        @Override
        public boolean inMemory() {
            return this.cachedOutputStream.inMemory;
        }

        @Override
        public long length() {
            return this.cachedOutputStream.totalLength;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
            this.cachedOutputStream.close();
        }
    }
}

