/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExceptionHandler;
import org.slf4j.LoggerFactory;

public class LoggingExceptionHandler
implements ExceptionHandler {
    private final CamelLogger logger;
    private final CamelContext camelContext;

    public LoggingExceptionHandler(CamelContext camelContext, Class<?> ownerType) {
        this(camelContext, new CamelLogger(LoggerFactory.getLogger(ownerType), LoggingLevel.WARN));
    }

    public LoggingExceptionHandler(CamelContext camelContext, Class<?> ownerType, LoggingLevel level) {
        this(camelContext, new CamelLogger(LoggerFactory.getLogger(ownerType), level));
    }

    public LoggingExceptionHandler(CamelContext camelContext, CamelLogger logger2) {
        this.camelContext = camelContext;
        this.logger = logger2;
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, null, exception);
    }

    @Override
    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    @Override
    public void handleException(String message, Exchange exchange, Throwable exception) {
        try {
            if (!this.isSuppressLogging()) {
                String msg = CamelExchangeException.createExceptionMessage(message, exchange, exception);
                if (this.isCausedByRollbackExchangeException(exception)) {
                    this.logger.log(msg);
                } else if (exception != null) {
                    this.logger.log(msg, exception);
                } else {
                    this.logger.log(msg);
                }
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    protected boolean isCausedByRollbackExchangeException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof RollbackExchangeException) {
            return true;
        }
        if (exception.getCause() != null) {
            return this.isCausedByRollbackExchangeException(exception.getCause());
        }
        return false;
    }

    protected boolean isSuppressLogging() {
        if (this.camelContext != null) {
            return (this.camelContext.getStatus().isStopping() || this.camelContext.getStatus().isStopped()) && this.camelContext.getShutdownStrategy().isTimeoutOccurred() && this.camelContext.getShutdownStrategy().isSuppressLoggingOnTimeout();
        }
        return false;
    }
}

