/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import jakarta.el.ValueReference;
import jakarta.el.VariableMapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.glassfish.expressly.lang.EvaluationContext;
import org.glassfish.expressly.lang.ExpressionBuilder;
import org.glassfish.expressly.parser.AstLiteralExpression;
import org.glassfish.expressly.parser.Node;
import org.glassfish.expressly.util.ReflectionUtil;

public final class ValueExpressionImpl
extends ValueExpression
implements Externalizable {
    private Class<?> expectedType;
    private String expression;
    private FunctionMapper functionMapper;
    private VariableMapper variableMapper;
    private transient Node node;

    public ValueExpressionImpl() {
    }

    public ValueExpressionImpl(String expr, Node node, FunctionMapper fnMapper, VariableMapper varMapper, Class<?> expectedType) {
        this.expression = expr;
        this.node = node;
        this.functionMapper = fnMapper;
        this.variableMapper = varMapper;
        this.expectedType = expectedType;
    }

    @Override
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    @Override
    public String getExpressionString() {
        return this.expression;
    }

    @Override
    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        return this.getNode().getType(new EvaluationContext(context, this.functionMapper, this.variableMapper));
    }

    @Override
    public ValueReference getValueReference(ELContext context) throws PropertyNotFoundException, ELException {
        return this.getNode().getValueReference(new EvaluationContext(context, this.functionMapper, this.variableMapper));
    }

    @Override
    public <T> T getValue(ELContext context) throws PropertyNotFoundException, ELException {
        EvaluationContext ctx = new EvaluationContext(context, this.functionMapper, this.variableMapper);
        ctx.notifyBeforeEvaluation(this.expression);
        Object value = this.getNode().getValue(ctx);
        if (this.expectedType != null) {
            try {
                value = ctx.convertToType(value, this.expectedType);
            }
            catch (IllegalArgumentException ex) {
                throw new ELException(ex);
            }
        }
        ctx.notifyAfterEvaluation(this.expression);
        return (T)value;
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    @Override
    public boolean isLiteralText() {
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ELException ele) {
            return false;
        }
    }

    @Override
    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        return this.getNode().isReadOnly(new EvaluationContext(context, this.functionMapper, this.variableMapper));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = in.readUTF();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
        this.functionMapper = (FunctionMapper)in.readObject();
        this.variableMapper = (VariableMapper)in.readObject();
    }

    @Override
    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        this.getNode().setValue(new EvaluationContext(context, this.functionMapper, this.variableMapper), value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expression);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(this.functionMapper);
        out.writeObject(this.variableMapper);
    }

    public String toString() {
        return "ValueExpression[" + this.expression + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ValueExpressionImpl)) {
            return false;
        }
        ValueExpressionImpl valueExpressionImpl = (ValueExpressionImpl)obj;
        return this.getNode().equals(valueExpressionImpl.getNode());
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expression);
        }
        return this.node;
    }
}

