/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.glassfish.expressly.util.MessageFactory;
import org.glassfish.expressly.util.ReflectionUtil;

public final class ValueExpressionLiteral
extends ValueExpression
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Object value;
    private Class<?> expectedType;

    public ValueExpressionLiteral() {
    }

    public ValueExpressionLiteral(Object value, Class<?> expectedType) {
        this.value = value;
        this.expectedType = expectedType;
    }

    @Override
    public <T> T getValue(ELContext context) {
        if (this.expectedType != null) {
            try {
                return (T)context.convertToType(this.value, this.expectedType);
            }
            catch (IllegalArgumentException ex) {
                throw new ELException(ex);
            }
        }
        return (T)this.value;
    }

    @Override
    public void setValue(ELContext context, Object value) {
        throw new PropertyNotWritableException(MessageFactory.get("error.value.literal.write", value));
    }

    @Override
    public boolean isReadOnly(ELContext context) {
        return true;
    }

    @Override
    public Class<?> getType(ELContext context) {
        return this.value != null ? this.value.getClass() : null;
    }

    @Override
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    @Override
    public String getExpressionString() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ValueExpressionLiteral && this.equals((ValueExpressionLiteral)obj);
    }

    public boolean equals(ValueExpressionLiteral ve) {
        return ve != null && this.value != null && ve.value != null && (this.value == ve.value || this.value.equals(ve.value));
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public boolean isLiteralText() {
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.value);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
    }
}

