/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly.lang;

import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import org.glassfish.expressly.lang.VariableMapperImpl;

public class VariableMapperFactory
extends VariableMapper {
    private final VariableMapper target;
    private VariableMapper momento;

    public VariableMapperFactory(VariableMapper target) {
        if (target == null) {
            throw new NullPointerException("Target VariableMapper cannot be null");
        }
        this.target = target;
    }

    public VariableMapper create() {
        return this.momento;
    }

    @Override
    public ValueExpression resolveVariable(String variable) {
        ValueExpression valueExpression = this.target.resolveVariable(variable);
        if (valueExpression != null) {
            if (this.momento == null) {
                this.momento = new VariableMapperImpl();
            }
            this.momento.setVariable(variable, valueExpression);
        }
        return valueExpression;
    }

    @Override
    public ValueExpression setVariable(String variable, ValueExpression expression) {
        throw new UnsupportedOperationException("Cannot Set Variables on Factory");
    }
}

