/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.MessageHistory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInflightRepository
extends ServiceSupport
implements InflightRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInflightRepository.class);
    private final LongAdder size = new LongAdder();
    private final ConcurrentMap<String, Exchange> inflight = new ConcurrentHashMap<String, Exchange>();
    private final ConcurrentMap<String, LongAdder> routeCount = new ConcurrentHashMap<String, LongAdder>();
    private boolean inflightExchangeEnabled;

    @Override
    public void add(Exchange exchange) {
        this.size.increment();
        if (this.inflightExchangeEnabled) {
            this.inflight.put(exchange.getExchangeId(), exchange);
        }
    }

    @Override
    public void remove(Exchange exchange) {
        this.size.decrement();
        if (this.inflightExchangeEnabled) {
            this.inflight.remove(exchange.getExchangeId());
        }
    }

    @Override
    public void add(Exchange exchange, String routeId) {
        LongAdder existing = (LongAdder)this.routeCount.get(routeId);
        if (existing != null) {
            existing.increment();
        }
    }

    @Override
    public void remove(Exchange exchange, String routeId) {
        LongAdder existing = (LongAdder)this.routeCount.get(routeId);
        if (existing != null) {
            existing.decrement();
        }
    }

    @Override
    public int size() {
        return this.size.intValue();
    }

    @Override
    public void addRoute(String routeId) {
        this.routeCount.putIfAbsent(routeId, new LongAdder());
    }

    @Override
    public void removeRoute(String routeId) {
        this.routeCount.remove(routeId);
    }

    @Override
    public int size(String routeId) {
        LongAdder existing = (LongAdder)this.routeCount.get(routeId);
        return existing != null ? existing.intValue() : 0;
    }

    @Override
    public boolean isInflightBrowseEnabled() {
        return this.inflightExchangeEnabled;
    }

    @Override
    public void setInflightBrowseEnabled(boolean inflightBrowseEnabled) {
        this.inflightExchangeEnabled = inflightBrowseEnabled;
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse() {
        return this.browse(null, -1, false);
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse(String fromRouteId) {
        return this.browse(fromRouteId, -1, false);
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse(int limit, boolean sortByLongestDuration) {
        return this.browse(null, limit, sortByLongestDuration);
    }

    @Override
    public Collection<InflightRepository.InflightExchange> browse(String fromRouteId, int limit, boolean sortByLongestDuration) {
        if (!this.inflightExchangeEnabled) {
            return Collections.emptyList();
        }
        Stream<Object> values2 = fromRouteId == null ? this.inflight.values().stream() : this.inflight.values().stream().filter(e -> fromRouteId.equals(e.getFromRouteId()));
        values2 = sortByLongestDuration ? values2.sorted((e1, e2) -> {
            long d1 = DefaultInflightRepository.getExchangeDuration(e1);
            long d2 = DefaultInflightRepository.getExchangeDuration(e2);
            return -1 * Long.compare(d1, d2);
        }) : values2.sorted(Comparator.comparing(Exchange::getExchangeId));
        if (limit > 0) {
            values2 = values2.limit(limit);
        }
        return values2.map(InflightExchangeEntry::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public InflightRepository.InflightExchange oldest(String fromRouteId) {
        if (!this.inflightExchangeEnabled) {
            return null;
        }
        Stream<Object> values2 = fromRouteId == null ? this.inflight.values().stream() : this.inflight.values().stream().filter(e -> fromRouteId.equals(e.getFromRouteId()));
        Exchange first = values2.sorted((e1, e2) -> {
            long d1 = DefaultInflightRepository.getExchangeDuration(e1);
            long d2 = DefaultInflightRepository.getExchangeDuration(e2);
            return -1 * Long.compare(d1, d2);
        }).findFirst().orElse(null);
        if (first != null) {
            return new InflightExchangeEntry(first);
        }
        return null;
    }

    @Override
    protected void doStop() throws Exception {
        int count = this.size();
        if (count > 0) {
            LOG.warn("Shutting down while there are still {} inflight exchanges.", (Object)count);
        } else {
            LOG.debug("Shutting down with no inflight exchanges.");
        }
        this.routeCount.clear();
    }

    private static long getExchangeDuration(Exchange exchange) {
        return exchange.getClock().elapsed();
    }

    private static final class InflightExchangeEntry
    implements InflightRepository.InflightExchange {
        private final Exchange exchange;

        private InflightExchangeEntry(Exchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public Exchange getExchange() {
            return this.exchange;
        }

        @Override
        public long getDuration() {
            return DefaultInflightRepository.getExchangeDuration(this.exchange);
        }

        @Override
        public long getElapsed() {
            List list = this.exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
            if (list == null || list.isEmpty()) {
                return 0L;
            }
            MessageHistory history = (MessageHistory)list.get(list.size() - 1);
            if (history != null) {
                long elapsed = history.getElapsed();
                if (elapsed == 0L) {
                    elapsed = history.getElapsedSinceCreated();
                }
                return elapsed;
            }
            return 0L;
        }

        @Override
        public String getNodeId() {
            return this.exchange.getExchangeExtension().getHistoryNodeId();
        }

        @Override
        public String getFromRouteId() {
            return this.exchange.getFromRouteId();
        }

        @Override
        public boolean isFromRemoteEndpoint() {
            if (this.exchange.getFromEndpoint() != null) {
                return this.exchange.getFromEndpoint().isRemote();
            }
            return false;
        }

        @Override
        public String getAtRouteId() {
            return ExchangeHelper.getAtRouteId(this.exchange);
        }

        public String toString() {
            return "InflightExchangeEntry[exchangeId=" + this.exchange.getExchangeId() + "]";
        }
    }
}

