/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.StaticService;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.ConsumerHealthCheck;
import org.apache.camel.spi.annotations.HealthCheck;
import org.apache.camel.support.service.ServiceSupport;

@HealthCheck(value="consumers-repository")
@DeferredContextBinding
public class ConsumersHealthCheckRepository
extends ServiceSupport
implements CamelContextAware,
HealthCheckRepository,
StaticService,
NonManagedService {
    private final ConcurrentMap<Consumer, org.apache.camel.health.HealthCheck> checks = new ConcurrentHashMap<Consumer, org.apache.camel.health.HealthCheck>();
    private volatile CamelContext context;
    private boolean enabled = true;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    @Override
    public String getId() {
        return "consumers";
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Stream<org.apache.camel.health.HealthCheck> stream() {
        return this.context != null && this.enabled ? this.context.getRoutes().stream().filter(route -> route.getId() != null).map(this::toConsumerHealthCheck) : Stream.empty();
    }

    private org.apache.camel.health.HealthCheck toConsumerHealthCheck(Route route) {
        return this.checks.computeIfAbsent(route.getConsumer(), r -> {
            String id = "consumer:" + route.getRouteId();
            ConsumerHealthCheck chc = new ConsumerHealthCheck(route, id);
            CamelContextAware.trySetCamelContext(chc, route.getCamelContext());
            return chc;
        });
    }
}

