/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.HasExpressionType;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="propertyExpression")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PropertyExpressionDefinition
implements HasExpressionType {
    @XmlAttribute(required=true)
    private String key;
    @XmlElementRef
    @Metadata(required=true)
    private ExpressionDefinition expression;

    public PropertyExpressionDefinition() {
    }

    protected PropertyExpressionDefinition(PropertyExpressionDefinition source2) {
        this.key = source2.key;
        this.expression = source2.expression != null ? source2.expression.copyDefinition() : null;
    }

    public PropertyExpressionDefinition(String key, Expression expression) {
        this.key = key;
        if (expression != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
        }
    }

    public PropertyExpressionDefinition copyDefinition() {
        return new PropertyExpressionDefinition(this);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public ExpressionDefinition getExpressionType() {
        return this.getExpression();
    }

    @Override
    public void setExpressionType(ExpressionDefinition expressionType) {
        this.setExpression(expressionType);
    }
}

