/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Configurer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurer
public class RedeliveryPolicy
implements Cloneable,
Serializable {
    public static final RedeliveryPolicy DEFAULT_POLICY = new RedeliveryPolicy();
    protected static Random randomNumberGenerator;
    private static final Lock LOCK;
    private static final long serialVersionUID = -338222777701473252L;
    private static final Logger LOG;
    protected long redeliveryDelay = 1000L;
    protected int maximumRedeliveries;
    protected long maximumRedeliveryDelay = 60000L;
    protected double backOffMultiplier = 2.0;
    protected boolean useExponentialBackOff;
    protected double collisionAvoidanceFactor = 0.15;
    protected boolean useCollisionAvoidance;
    protected LoggingLevel retriesExhaustedLogLevel = LoggingLevel.ERROR;
    protected LoggingLevel retryAttemptedLogLevel = LoggingLevel.DEBUG;
    protected int retryAttemptedLogInterval = 1;
    protected boolean logStackTrace = true;
    protected boolean logRetryStackTrace;
    protected boolean logHandled;
    protected boolean logContinued;
    protected boolean logExhausted = true;
    protected boolean logNewException = true;
    protected Boolean logExhaustedMessageHistory;
    protected Boolean logExhaustedMessageBody;
    protected boolean logRetryAttempted = true;
    protected String delayPattern;
    protected boolean asyncDelayedRedelivery;
    protected boolean allowRedeliveryWhileStopping = true;
    protected String exchangeFormatterRef;

    public String toString() {
        return "RedeliveryPolicy[maximumRedeliveries=" + this.maximumRedeliveries + ", redeliveryDelay=" + this.redeliveryDelay + ", maximumRedeliveryDelay=" + this.maximumRedeliveryDelay + ", asyncDelayedRedelivery=" + this.asyncDelayedRedelivery + ", allowRedeliveryWhileStopping=" + this.allowRedeliveryWhileStopping + ", retriesExhaustedLogLevel=" + this.retriesExhaustedLogLevel + ", retryAttemptedLogLevel=" + this.retryAttemptedLogLevel + ", retryAttemptedLogInterval=" + this.retryAttemptedLogInterval + ", logRetryAttempted=" + this.logRetryAttempted + ", logStackTrace=" + this.logStackTrace + ", logRetryStackTrace=" + this.logRetryStackTrace + ", logHandled=" + this.logHandled + ", logContinued=" + this.logContinued + ", logExhausted=" + this.logExhausted + ", logNewException=" + this.logNewException + ", logExhaustedMessageHistory=" + this.logExhaustedMessageHistory + ", logExhaustedMessageBody=" + this.logExhaustedMessageBody + ", useExponentialBackOff=" + this.useExponentialBackOff + ", backOffMultiplier=" + this.backOffMultiplier + ", useCollisionAvoidance=" + this.useCollisionAvoidance + ", collisionAvoidanceFactor=" + this.collisionAvoidanceFactor + ", delayPattern=" + this.delayPattern + ", exchangeFormatterRef=" + this.exchangeFormatterRef + "]";
    }

    public RedeliveryPolicy copy() {
        try {
            return (RedeliveryPolicy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public boolean shouldRedeliver(Exchange exchange, int redeliveryCounter, Predicate retryWhile) {
        if (retryWhile != null) {
            return retryWhile.matches(exchange);
        }
        if (this.getMaximumRedeliveries() < 0) {
            return true;
        }
        return redeliveryCounter <= this.getMaximumRedeliveries();
    }

    public long sleep(long redeliveryDelay, int redeliveryCounter) throws InterruptedException {
        if ((redeliveryDelay = this.calculateRedeliveryDelay(redeliveryDelay, redeliveryCounter)) > 0L) {
            this.sleep(redeliveryDelay);
        }
        return redeliveryDelay;
    }

    public void sleep(long redeliveryDelay) throws InterruptedException {
        LOG.debug("Sleeping for: {} millis until attempting redelivery", (Object)redeliveryDelay);
        Thread.sleep(redeliveryDelay);
    }

    public long calculateRedeliveryDelay(long previousDelay, int redeliveryCounter) {
        if (ObjectHelper.isNotEmpty(this.delayPattern)) {
            return RedeliveryPolicy.calculateRedeliverDelayUsingPattern(this.delayPattern, redeliveryCounter);
        }
        long redeliveryDelayResult = previousDelay == 0L ? this.redeliveryDelay : (this.useExponentialBackOff && this.backOffMultiplier > 1.0 ? Math.round(this.backOffMultiplier * (double)previousDelay) : previousDelay);
        if (this.useCollisionAvoidance) {
            Random random = RedeliveryPolicy.getRandomNumberGenerator();
            double variance = (random.nextBoolean() ? this.collisionAvoidanceFactor : -this.collisionAvoidanceFactor) * random.nextDouble();
            redeliveryDelayResult += (long)((double)redeliveryDelayResult * variance);
        }
        if (this.maximumRedeliveryDelay > 0L && redeliveryDelayResult > this.maximumRedeliveryDelay) {
            redeliveryDelayResult = this.maximumRedeliveryDelay;
        }
        return redeliveryDelayResult;
    }

    protected static long calculateRedeliverDelayUsingPattern(String delayPattern, int redeliveryCounter) {
        String[] groups2 = delayPattern.split(";");
        long answer = 0L;
        for (String group : groups2) {
            long delay = Long.parseLong(StringHelper.after(group, ":"));
            int count = Integer.parseInt(StringHelper.before(group, ":"));
            if (count > redeliveryCounter) break;
            answer = delay;
        }
        return answer;
    }

    public RedeliveryPolicy redeliveryDelay(long delay) {
        this.setRedeliveryDelay(delay);
        return this;
    }

    public RedeliveryPolicy maximumRedeliveries(int maximumRedeliveries) {
        this.setMaximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public RedeliveryPolicy useCollisionAvoidance() {
        this.setUseCollisionAvoidance(true);
        return this;
    }

    public RedeliveryPolicy useExponentialBackOff() {
        this.setUseExponentialBackOff(true);
        return this;
    }

    public RedeliveryPolicy backOffMultiplier(double multiplier) {
        this.useExponentialBackOff();
        this.setBackOffMultiplier(multiplier);
        return this;
    }

    public RedeliveryPolicy collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.useCollisionAvoidance();
        this.setCollisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public RedeliveryPolicy maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.setMaximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public RedeliveryPolicy retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public RedeliveryPolicy retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public RedeliveryPolicy retryAttemptedLogInterval(int logRetryAttemptedInterval) {
        this.setRetryAttemptedLogInterval(logRetryAttemptedInterval);
        return this;
    }

    public RedeliveryPolicy logRetryAttempted(boolean logRetryAttempted) {
        this.setLogRetryAttempted(logRetryAttempted);
        return this;
    }

    public RedeliveryPolicy logStackTrace(boolean logStackTrace) {
        this.setLogStackTrace(logStackTrace);
        return this;
    }

    public RedeliveryPolicy logRetryStackTrace(boolean logRetryStackTrace) {
        this.setLogRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public RedeliveryPolicy logHandled(boolean logHandled) {
        this.setLogHandled(logHandled);
        return this;
    }

    public RedeliveryPolicy logNewException(boolean logNewException) {
        this.setLogNewException(logNewException);
        return this;
    }

    public RedeliveryPolicy logExhausted(boolean logExhausted) {
        this.setLogExhausted(logExhausted);
        return this;
    }

    public RedeliveryPolicy logExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.setLogExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public RedeliveryPolicy logExhaustedMessageBody(boolean logExhaustedMessageBody) {
        this.setLogExhaustedMessageBody(logExhaustedMessageBody);
        return this;
    }

    public RedeliveryPolicy delayPattern(String delayPattern) {
        this.setDelayPattern(delayPattern);
        return this;
    }

    public RedeliveryPolicy disableRedelivery() {
        this.setMaximumRedeliveries(0);
        return this;
    }

    public RedeliveryPolicy asyncDelayedRedelivery() {
        this.setAsyncDelayedRedelivery(true);
        return this;
    }

    public RedeliveryPolicy allowRedeliveryWhileStopping(boolean redeliverWhileStopping) {
        this.setAllowRedeliveryWhileStopping(redeliverWhileStopping);
        return this;
    }

    public RedeliveryPolicy exchangeFormatterRef(String exchangeFormatterRef) {
        this.setExchangeFormatterRef(exchangeFormatterRef);
        return this;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(long redeliverDelay) {
        this.redeliveryDelay = redeliverDelay;
        if (this.maximumRedeliveryDelay > 0L && redeliverDelay > this.maximumRedeliveryDelay) {
            this.maximumRedeliveryDelay = redeliverDelay;
        }
    }

    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public long getCollisionAvoidancePercent() {
        return Math.round(this.collisionAvoidanceFactor * 100.0);
    }

    public void setCollisionAvoidancePercent(double collisionAvoidancePercent) {
        this.collisionAvoidanceFactor = collisionAvoidancePercent * 0.01;
    }

    public double getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public long getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public boolean isUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    protected static Random getRandomNumberGenerator() {
        LOCK.lock();
        try {
            if (randomNumberGenerator == null) {
                randomNumberGenerator = new Random();
            }
            Random random = randomNumberGenerator;
            return random;
        }
        finally {
            LOCK.unlock();
        }
    }

    public void setRetriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public LoggingLevel getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public LoggingLevel getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public int getRetryAttemptedLogInterval() {
        return this.retryAttemptedLogInterval;
    }

    public void setRetryAttemptedLogInterval(int retryAttemptedLogInterval) {
        this.retryAttemptedLogInterval = retryAttemptedLogInterval;
    }

    public String getDelayPattern() {
        return this.delayPattern;
    }

    public void setDelayPattern(String delayPattern) {
        this.delayPattern = delayPattern;
    }

    public boolean isLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(boolean logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public boolean isLogRetryStackTrace() {
        return this.logRetryStackTrace;
    }

    public void setLogRetryStackTrace(boolean logRetryStackTrace) {
        this.logRetryStackTrace = logRetryStackTrace;
    }

    public boolean isLogHandled() {
        return this.logHandled;
    }

    public void setLogHandled(boolean logHandled) {
        this.logHandled = logHandled;
    }

    public boolean isLogNewException() {
        return this.logNewException;
    }

    public void setLogNewException(boolean logNewException) {
        this.logNewException = logNewException;
    }

    public boolean isLogContinued() {
        return this.logContinued;
    }

    public void setLogContinued(boolean logContinued) {
        this.logContinued = logContinued;
    }

    public boolean isLogRetryAttempted() {
        return this.logRetryAttempted;
    }

    public void setLogRetryAttempted(boolean logRetryAttempted) {
        this.logRetryAttempted = logRetryAttempted;
    }

    public boolean isLogExhausted() {
        return this.logExhausted;
    }

    public void setLogExhausted(boolean logExhausted) {
        this.logExhausted = logExhausted;
    }

    public boolean isLogExhaustedMessageHistory() {
        return this.logExhaustedMessageHistory == null || this.logExhaustedMessageHistory != false;
    }

    public Boolean getLogExhaustedMessageHistory() {
        return this.logExhaustedMessageHistory;
    }

    public void setLogExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.logExhaustedMessageHistory = logExhaustedMessageHistory;
    }

    public boolean isLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody != null && this.logExhaustedMessageBody != false;
    }

    public Boolean getLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public boolean isAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(boolean asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public boolean isAllowRedeliveryWhileStopping() {
        return this.allowRedeliveryWhileStopping;
    }

    public void setAllowRedeliveryWhileStopping(boolean allowRedeliveryWhileStopping) {
        this.allowRedeliveryWhileStopping = allowRedeliveryWhileStopping;
    }

    public String getExchangeFormatterRef() {
        return this.exchangeFormatterRef;
    }

    public void setExchangeFormatterRef(String exchangeFormatterRef) {
        this.exchangeFormatterRef = exchangeFormatterRef;
    }

    static {
        LOCK = new ReentrantLock();
        LOG = LoggerFactory.getLogger(RedeliveryPolicy.class);
    }
}

