/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.rest;

import org.apache.camel.Route;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.processor.RestBindingAdviceFactory;
import org.apache.camel.support.processor.RestBindingConfiguration;

public class RestBindingReifier
extends AbstractReifier {
    private final RestBindingDefinition definition;

    public RestBindingReifier(Route route, RestBindingDefinition definition) {
        super(route);
        this.definition = definition;
    }

    public RestBindingAdvice createRestBindingAdvice() throws Exception {
        RestConfiguration config = CamelContextHelper.getRestConfiguration(this.camelContext, this.definition.getComponent());
        RestBindingConfiguration rbc = new RestBindingConfiguration();
        String mode = config.getBindingMode().name();
        if (this.definition.getBindingMode() != null) {
            mode = this.parse(RestBindingMode.class, this.definition.getBindingMode()).name();
        }
        rbc.setBindingMode(mode);
        rbc.setBindingPackageScan(config.getBindingPackageScan());
        boolean cors = config.isEnableCORS();
        if (this.definition.getEnableCORS() != null) {
            cors = this.parseBoolean(this.definition.getEnableCORS(), false);
        }
        rbc.setEnableCORS(cors);
        boolean noContentResponse = config.isEnableNoContentResponse();
        if (this.definition.getEnableNoContentResponse() != null) {
            noContentResponse = this.parseBoolean(this.definition.getEnableNoContentResponse(), false);
        }
        rbc.setEnableNoContentResponse(noContentResponse);
        boolean skip = config.isSkipBindingOnErrorCode();
        if (this.definition.getSkipBindingOnErrorCode() != null) {
            skip = this.parseBoolean(this.definition.getSkipBindingOnErrorCode(), false);
        }
        rbc.setSkipBindingOnErrorCode(skip);
        boolean validation = config.isClientRequestValidation();
        if (this.definition.getClientRequestValidation() != null) {
            validation = this.parseBoolean(this.definition.getClientRequestValidation(), false);
        }
        rbc.setClientRequestValidation(validation);
        rbc.setConsumes(this.parseString(this.definition.getConsumes()));
        rbc.setProduces(this.parseString(this.definition.getProduces()));
        rbc.setCorsHeaders(config.getCorsHeaders());
        rbc.setQueryDefaultValues(this.definition.getDefaultValues());
        rbc.setQueryAllowedValues(this.definition.getAllowedValues());
        rbc.setRequiredBody(this.definition.getRequiredBody() != null && this.definition.getRequiredBody() != false);
        rbc.setRequiredQueryParameters(this.definition.getRequiredQueryParameters());
        rbc.setRequiredHeaders(this.definition.getRequiredHeaders());
        rbc.setType(this.parseString(this.definition.getType()));
        rbc.setTypeClass(this.definition.getTypeClass());
        rbc.setOutType(this.parseString(this.definition.getOutType()));
        rbc.setOutTypeClass(this.definition.getOutTypeClass());
        return RestBindingAdviceFactory.build(this.camelContext, rbc);
    }
}

