/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;

public class SimpleTypeConverter
implements TypeConverter {
    private final boolean allowNull;
    private final ConversionMethod method;

    public SimpleTypeConverter(boolean allowNull, ConversionMethod method) {
        this.allowNull = allowNull;
        this.method = method;
    }

    @Override
    public boolean allowNull() {
        return this.allowNull;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) throws TypeConversionException {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        T t2 = this.convertTo(type, null, value);
        if (t2 == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return t2;
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        T t2 = this.convertTo(type, exchange, value);
        if (t2 == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return t2;
    }

    @Override
    public <T> T tryConvertTo(Class<T> type, Object value) {
        try {
            return this.convertTo(type, null, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return this.convertTo(type, exchange, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
        try {
            return (T)this.method.doConvert(type, exchange, value);
        }
        catch (TypeConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TypeConversionException(value, type, e);
        }
    }

    @FunctionalInterface
    public static interface ConversionMethod {
        public Object doConvert(Class<?> var1, Exchange var2, Object var3) throws Exception;
    }
}

