/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.option.ParamAdder;
import org.kiwiproject.consul.option.TokenQueryOptions;

@Generated(from="TokenQueryOptions", generator="Immutables")
public final class ImmutableTokenQueryOptions
extends TokenQueryOptions {
    private final ImmutableList<String> toQueryParameters;
    private final ImmutableMap<String, String> toHeaders;
    @Nullable
    private final String policy;
    @Nullable
    private final String role;
    @Nullable
    private final String authMethod;
    @Nullable
    private final String authMethodNamespace;
    @Nullable
    private final String namespace;

    private ImmutableTokenQueryOptions(ImmutableList<String> toQueryParameters, ImmutableMap<String, String> toHeaders, @Nullable String policy, @Nullable String role, @Nullable String authMethod, @Nullable String authMethodNamespace, @Nullable String namespace) {
        this.toQueryParameters = toQueryParameters;
        this.toHeaders = toHeaders;
        this.policy = policy;
        this.role = role;
        this.authMethod = authMethod;
        this.authMethodNamespace = authMethodNamespace;
        this.namespace = namespace;
    }

    public ImmutableList<String> toQueryParameters() {
        return this.toQueryParameters;
    }

    public ImmutableMap<String, String> toHeaders() {
        return this.toHeaders;
    }

    @Override
    public Optional<String> getPolicy() {
        return Optional.ofNullable(this.policy);
    }

    @Override
    public Optional<String> getRole() {
        return Optional.ofNullable(this.role);
    }

    @Override
    public Optional<String> getAuthMethod() {
        return Optional.ofNullable(this.authMethod);
    }

    @Override
    public Optional<String> getAuthMethodNamespace() {
        return Optional.ofNullable(this.authMethodNamespace);
    }

    @Override
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public final ImmutableTokenQueryOptions withToQueryParameters(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTokenQueryOptions(newValue, this.toHeaders, this.policy, this.role, this.authMethod, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withToQueryParameters(Iterable<String> elements) {
        if (this.toQueryParameters == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTokenQueryOptions(newValue, this.toHeaders, this.policy, this.role, this.authMethod, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withToHeaders(Map<String, ? extends String> entries) {
        if (this.toHeaders == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTokenQueryOptions(this.toQueryParameters, newValue, this.policy, this.role, this.authMethod, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withPolicy(String value) {
        String newValue = Objects.requireNonNull(value, "policy");
        if (Objects.equals(this.policy, newValue)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, newValue, this.role, this.authMethod, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withPolicy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.policy, value)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, value, this.role, this.authMethod, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withRole(String value) {
        String newValue = Objects.requireNonNull(value, "role");
        if (Objects.equals(this.role, newValue)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, newValue, this.authMethod, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withRole(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.role, value)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, value, this.authMethod, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withAuthMethod(String value) {
        String newValue = Objects.requireNonNull(value, "authMethod");
        if (Objects.equals(this.authMethod, newValue)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, this.role, newValue, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withAuthMethod(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authMethod, value)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, this.role, value, this.authMethodNamespace, this.namespace);
    }

    public final ImmutableTokenQueryOptions withAuthMethodNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "authMethodNamespace");
        if (Objects.equals(this.authMethodNamespace, newValue)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, this.role, this.authMethod, newValue, this.namespace);
    }

    public final ImmutableTokenQueryOptions withAuthMethodNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authMethodNamespace, value)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, this.role, this.authMethod, value, this.namespace);
    }

    public final ImmutableTokenQueryOptions withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (Objects.equals(this.namespace, newValue)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, this.role, this.authMethod, this.authMethodNamespace, newValue);
    }

    public final ImmutableTokenQueryOptions withNamespace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.namespace, value)) {
            return this;
        }
        return new ImmutableTokenQueryOptions(this.toQueryParameters, this.toHeaders, this.policy, this.role, this.authMethod, this.authMethodNamespace, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenQueryOptions && this.equalTo(0, (ImmutableTokenQueryOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableTokenQueryOptions another) {
        return this.toQueryParameters.equals(another.toQueryParameters) && this.toHeaders.equals(another.toHeaders) && Objects.equals(this.policy, another.policy) && Objects.equals(this.role, another.role) && Objects.equals(this.authMethod, another.authMethod) && Objects.equals(this.authMethodNamespace, another.authMethodNamespace) && Objects.equals(this.namespace, another.namespace);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.toQueryParameters.hashCode();
        h2 += (h2 << 5) + this.toHeaders.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.policy);
        h2 += (h2 << 5) + Objects.hashCode(this.role);
        h2 += (h2 << 5) + Objects.hashCode(this.authMethod);
        h2 += (h2 << 5) + Objects.hashCode(this.authMethodNamespace);
        h2 += (h2 << 5) + Objects.hashCode(this.namespace);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TokenQueryOptions").omitNullValues().add("toQueryParameters", this.toQueryParameters).add("toHeaders", this.toHeaders).add("policy", this.policy).add("role", this.role).add("authMethod", this.authMethod).add("authMethodNamespace", this.authMethodNamespace).add("namespace", this.namespace).toString();
    }

    public static ImmutableTokenQueryOptions copyOf(TokenQueryOptions instance) {
        if (instance instanceof ImmutableTokenQueryOptions) {
            return (ImmutableTokenQueryOptions)instance;
        }
        return ImmutableTokenQueryOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TokenQueryOptions", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> toHeaders = ImmutableMap.builder();
        @Nullable
        private String policy;
        @Nullable
        private String role;
        @Nullable
        private String authMethod;
        @Nullable
        private String authMethodNamespace;
        @Nullable
        private String namespace;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenQueryOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ParamAdder instance;
            if (object instanceof TokenQueryOptions) {
                Optional<String> policyOptional;
                Optional<String> authMethodNamespaceOptional;
                Optional<String> authMethodOptional;
                Optional<String> roleOptional;
                instance = (TokenQueryOptions)object;
                Optional<String> namespaceOptional = ((TokenQueryOptions)instance).getNamespace();
                if (namespaceOptional.isPresent()) {
                    this.namespace(namespaceOptional);
                }
                if ((roleOptional = ((TokenQueryOptions)instance).getRole()).isPresent()) {
                    this.role(roleOptional);
                }
                if ((authMethodOptional = ((TokenQueryOptions)instance).getAuthMethod()).isPresent()) {
                    this.authMethod(authMethodOptional);
                }
                if ((authMethodNamespaceOptional = ((TokenQueryOptions)instance).getAuthMethodNamespace()).isPresent()) {
                    this.authMethodNamespace(authMethodNamespaceOptional);
                }
                if ((policyOptional = ((TokenQueryOptions)instance).getPolicy()).isPresent()) {
                    this.policy(policyOptional);
                }
            }
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.addAllToQueryParameters(instance.toQueryParameters());
                this.putAllToHeaders(instance.toHeaders());
            }
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String element) {
            this.toQueryParameters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String ... elements) {
            this.toQueryParameters.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQueryParameters(Iterable<String> elements) {
            this.toQueryParameters = ImmutableList.builder();
            return this.addAllToQueryParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToQueryParameters(Iterable<String> elements) {
            this.toQueryParameters.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(String key, String value) {
            this.toHeaders.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putToHeaders(Map.Entry<String, ? extends String> entry) {
            this.toHeaders.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toHeaders(Map<String, ? extends String> entries) {
            this.toHeaders = ImmutableMap.builder();
            return this.putAllToHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllToHeaders(Map<String, ? extends String> entries) {
            this.toHeaders.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policy(String policy) {
            this.policy = Objects.requireNonNull(policy, "policy");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder policy(Optional<String> policy) {
            this.policy = policy.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder role(String role) {
            this.role = Objects.requireNonNull(role, "role");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder role(Optional<String> role) {
            this.role = role.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authMethod(String authMethod) {
            this.authMethod = Objects.requireNonNull(authMethod, "authMethod");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authMethod(Optional<String> authMethod) {
            this.authMethod = authMethod.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authMethodNamespace(String authMethodNamespace) {
            this.authMethodNamespace = Objects.requireNonNull(authMethodNamespace, "authMethodNamespace");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authMethodNamespace(Optional<String> authMethodNamespace) {
            this.authMethodNamespace = authMethodNamespace.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(Optional<String> namespace) {
            this.namespace = namespace.orElse(null);
            return this;
        }

        public ImmutableTokenQueryOptions build() {
            return new ImmutableTokenQueryOptions((ImmutableList<String>)this.toQueryParameters.build(), this.toHeaders.build(), this.policy, this.role, this.authMethod, this.authMethodNamespace, this.namespace);
        }
    }
}

