/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.StartupStep;
import org.apache.camel.impl.DefaultModel;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.impl.PreconditionHelper;
import org.apache.camel.impl.engine.DefaultExecutorServiceManager;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.impl.engine.SimpleCamelContext;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.InvertingPackageScanFilter;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.LocalBeanRepositoryAware;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorKey;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.LocalBeanRegistry;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.NamedThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelContext
extends SimpleCamelContext
implements ModelCamelContext {
    private static final ThreadLocal<Map<String, Object>> OPTIONS = new NamedThreadLocal<Map>("CamelContextOptions", HashMap::new);
    private static final String OPTION_NO_START = "OptionNoStart";
    private static final String OPTION_DISABLE_JMX = "OptionDisableJMX";
    private static final String OPTION_EXCLUDE_ROUTES = "OptionExcludeRoutes";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCamelContext.class);
    private static final UuidGenerator UUID = new SimpleUuidGenerator();
    private final Model model = new DefaultModel(this);

    public DefaultCamelContext() {
        this(true);
    }

    public DefaultCamelContext(BeanRepository repository) {
        this(new DefaultRegistry(repository));
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.getCamelContextExtension().setRegistry(registry);
    }

    public DefaultCamelContext(boolean init) {
        super(init);
        this.setModelReifierFactory(this.createModelReifierFactory());
        if (DefaultCamelContext.isDisableJmx()) {
            this.disableJMX();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        OPTIONS.remove();
    }

    @Override
    protected void doDumpRoutes() {
        DumpRoutesStrategy strategy = CamelContextHelper.findSingleByType(this, DumpRoutesStrategy.class);
        if (strategy == null) {
            strategy = this.getCamelContextExtension().getContextPlugin(DumpRoutesStrategy.class);
        }
        if (strategy != null) {
            strategy.dumpRoutes(this.getDumpRoutes());
        }
    }

    public static void setNoStart(boolean b) {
        DefaultCamelContext.getOptions().put(OPTION_NO_START, b);
    }

    public static boolean isNoStart() {
        return (Boolean)DefaultCamelContext.getOptions().getOrDefault(OPTION_NO_START, Boolean.FALSE);
    }

    public static void setDisableJmx(boolean b) {
        DefaultCamelContext.getOptions().put(OPTION_DISABLE_JMX, b);
    }

    public static boolean isDisableJmx() {
        return (Boolean)DefaultCamelContext.getOptions().getOrDefault(OPTION_DISABLE_JMX, Boolean.getBoolean("org.apache.camel.jmx.disabled"));
    }

    @Override
    public String getTestExcludeRoutes() {
        return DefaultCamelContext.getExcludeRoutes();
    }

    public static String getExcludeRoutes() {
        return (String)DefaultCamelContext.getOptions().get(OPTION_EXCLUDE_ROUTES);
    }

    public static void setExcludeRoutes(String s2) {
        DefaultCamelContext.getOptions().put(OPTION_EXCLUDE_ROUTES, s2);
    }

    public static void clearOptions() {
        OPTIONS.get().clear();
    }

    private static Map<String, Object> getOptions() {
        return OPTIONS.get();
    }

    @Override
    public void start() {
        if (DefaultCamelContext.isNoStart()) {
            LOG.trace("Ignoring start() as NO_START is true");
            return;
        }
        if (!this.isStarted() && !this.isStarting()) {
            StopWatch watch = new StopWatch();
            super.start();
            LOG.debug("start() took {} millis", (Object)watch.taken());
        } else {
            LOG.trace("Ignoring start() as Camel is already started");
        }
    }

    @Override
    protected PackageScanClassResolver createPackageScanClassResolver() {
        PackageScanClassResolver resolver = super.createPackageScanClassResolver();
        String excluded = DefaultCamelContext.getExcludeRoutes();
        if (ObjectHelper.isNotEmpty(excluded)) {
            HashSet excludedClasses = new HashSet();
            for (String str : excluded.split(",")) {
                excludedClasses.add(this.getClassResolver().resolveClass(str));
            }
            resolver.addFilter(new InvertingPackageScanFilter(new AssignableToPackageScanFilter(excludedClasses)));
        }
        return resolver;
    }

    @Override
    public void addModelLifecycleStrategy(ModelLifecycleStrategy modelLifecycleStrategy) {
        this.model.addModelLifecycleStrategy(modelLifecycleStrategy);
    }

    @Override
    public List<ModelLifecycleStrategy> getModelLifecycleStrategies() {
        return this.model.getModelLifecycleStrategies();
    }

    @Override
    public void addRouteConfiguration(RouteConfigurationDefinition routesConfiguration) {
        this.model.addRouteConfiguration(routesConfiguration);
    }

    @Override
    public void addRouteConfigurations(List<RouteConfigurationDefinition> routesConfigurations) {
        this.model.addRouteConfigurations(routesConfigurations);
    }

    @Override
    public List<RouteConfigurationDefinition> getRouteConfigurationDefinitions() {
        return this.model.getRouteConfigurationDefinitions();
    }

    @Override
    public RouteConfigurationDefinition getRouteConfigurationDefinition(String id) {
        return this.model.getRouteConfigurationDefinition(id);
    }

    @Override
    public void removeRouteConfiguration(RouteConfigurationDefinition routeConfigurationDefinition) throws Exception {
        this.model.removeRouteConfiguration(routeConfigurationDefinition);
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions() {
        return this.model.getRouteDefinitions();
    }

    @Override
    public RouteDefinition getRouteDefinition(String id) {
        return this.model.getRouteDefinition(id);
    }

    @Override
    public void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        this.model.addRouteDefinitions(routeDefinitions);
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.model.addRouteDefinition(routeDefinition);
    }

    @Override
    public void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        if (!this.isLockModel()) {
            this.model.removeRouteDefinitions(routeDefinitions);
        }
    }

    @Override
    public void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        if (!this.isLockModel()) {
            this.model.removeRouteDefinition(routeDefinition);
        }
    }

    @Override
    public List<RouteTemplateDefinition> getRouteTemplateDefinitions() {
        return this.model.getRouteTemplateDefinitions();
    }

    @Override
    public RouteTemplateDefinition getRouteTemplateDefinition(String id) {
        return this.model.getRouteTemplateDefinition(id);
    }

    @Override
    public void addRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        this.model.addRouteTemplateDefinitions(routeTemplateDefinitions);
    }

    @Override
    public void addRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        this.model.addRouteTemplateDefinition(routeTemplateDefinition);
    }

    @Override
    public void removeRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinitions(routeTemplateDefinitions);
        }
    }

    @Override
    public void removeRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinition(routeTemplateDefinition);
        }
    }

    @Override
    public void removeRouteTemplateDefinitions(String pattern) throws Exception {
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinitions(pattern);
        }
    }

    @Override
    public void addRouteTemplateDefinitionConverter(String templateIdPattern, RouteTemplateDefinition.Converter converter) {
        this.model.addRouteTemplateDefinitionConverter(templateIdPattern, converter);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, parameters);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, Map<String, Object> parameters) throws Exception {
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, prefixId, parameters);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, RouteTemplateContext routeTemplateContext) throws Exception {
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, prefixId, routeTemplateContext);
    }

    @Override
    public void addRouteFromTemplatedRoute(TemplatedRouteDefinition templatedRouteDefinition) throws Exception {
        this.model.addRouteFromTemplatedRoute(templatedRouteDefinition);
    }

    @Override
    public void removeRouteTemplates(String pattern) throws Exception {
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinitions(pattern);
        }
    }

    @Override
    public List<RestDefinition> getRestDefinitions() {
        return this.model.getRestDefinitions();
    }

    @Override
    public void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        this.model.addRestDefinitions(restDefinitions, addToRoutes);
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.model.setDataFormats(dataFormats);
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.model.getDataFormats();
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        return this.model.resolveDataFormatDefinition(name);
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition(String id) {
        return this.model.getProcessorDefinition(id);
    }

    @Override
    public <T extends ProcessorDefinition<T>> T getProcessorDefinition(String id, Class<T> type) {
        return this.model.getProcessorDefinition(id, type);
    }

    @Override
    public void setValidators(List<ValidatorDefinition> validators) {
        this.model.setValidators(validators);
    }

    @Override
    public Resilience4jConfigurationDefinition getResilience4jConfiguration(String id) {
        return this.model.getResilience4jConfiguration(id);
    }

    @Override
    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        this.model.setResilience4jConfiguration(configuration);
    }

    @Override
    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> configurations) {
        this.model.setResilience4jConfigurations(configurations);
    }

    @Override
    public void addResilience4jConfiguration(String id, Resilience4jConfigurationDefinition configuration) {
        this.model.addResilience4jConfiguration(id, configuration);
    }

    @Override
    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration(String id) {
        return this.model.getFaultToleranceConfiguration(id);
    }

    @Override
    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        this.model.setFaultToleranceConfiguration(configuration);
    }

    @Override
    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> configurations) {
        this.model.setFaultToleranceConfigurations(configurations);
    }

    @Override
    public void addFaultToleranceConfiguration(String id, FaultToleranceConfigurationDefinition configuration) {
        this.model.addFaultToleranceConfiguration(id, configuration);
    }

    @Override
    public List<ValidatorDefinition> getValidators() {
        return this.model.getValidators();
    }

    @Override
    public void setTransformers(List<TransformerDefinition> transformers) {
        this.model.setTransformers(transformers);
    }

    @Override
    public List<TransformerDefinition> getTransformers() {
        return this.model.getTransformers();
    }

    @Override
    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        return this.model.getServiceCallConfiguration(serviceName);
    }

    @Override
    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        this.model.setServiceCallConfiguration(configuration);
    }

    @Override
    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        this.model.setServiceCallConfigurations(configurations);
    }

    @Override
    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        this.model.addServiceCallConfiguration(serviceName, configuration);
    }

    @Override
    public void setRouteFilterPattern(String include, String exclude) {
        this.model.setRouteFilterPattern(include, exclude);
    }

    @Override
    public void setRouteFilter(Function<RouteDefinition, Boolean> filter) {
        this.model.setRouteFilter(filter);
    }

    @Override
    public Function<RouteDefinition, Boolean> getRouteFilter() {
        return this.model.getRouteFilter();
    }

    @Override
    public void addCustomBean(BeanFactoryDefinition<?> bean) {
        this.model.addCustomBean(bean);
    }

    @Override
    public List<BeanFactoryDefinition<?>> getCustomBeans() {
        return this.model.getCustomBeans();
    }

    @Override
    public ModelReifierFactory getModelReifierFactory() {
        return this.model.getModelReifierFactory();
    }

    @Override
    public void setModelReifierFactory(ModelReifierFactory modelReifierFactory) {
        this.model.setModelReifierFactory(modelReifierFactory);
    }

    @Override
    protected void bindDataFormats() throws Exception {
        if (this.model != null) {
            for (Map.Entry<String, DataFormatDefinition> e : this.model.getDataFormats().entrySet()) {
                String id = e.getKey();
                DataFormatDefinition def = e.getValue();
                LOG.debug("Creating Dataformat with id: {} and definition: {}", (Object)id, (Object)def);
                DataFormat df = this.model.getModelReifierFactory().createDataFormat(this, def);
                this.addService(df, true);
                this.getRegistry().bind(id, df);
            }
        }
    }

    @Override
    protected void shutdownRouteService(RouteService routeService) throws Exception {
        this.getLock().lock();
        try {
            RouteDefinition rd;
            if (this.model != null && (rd = this.model.getRouteDefinition(routeService.getId())) != null) {
                this.model.getRouteDefinitions().remove(rd);
            }
            super.shutdownRouteService(routeService);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    protected boolean isStreamCachingInUse() throws Exception {
        boolean streamCachingInUse = super.isStreamCachingInUse();
        if (!streamCachingInUse) {
            for (RouteDefinition route : this.model.getRouteDefinitions()) {
                Boolean routeCache = CamelContextHelper.parseBoolean(this, route.getStreamCache());
                if (routeCache == null || !routeCache.booleanValue()) continue;
                streamCachingInUse = true;
                break;
            }
        }
        return streamCachingInUse;
    }

    @Override
    public void startRouteDefinitions() throws Exception {
        List<RouteDefinition> routeDefinitions = this.model.getRouteDefinitions();
        if (routeDefinitions != null) {
            ArrayList<RouteDefinition> toBeStarted = new ArrayList<RouteDefinition>(routeDefinitions);
            this.startRouteDefinitions(toBeStarted);
        }
    }

    @Override
    public void removeRouteDefinitionsFromTemplate() throws Exception {
        ArrayList<RouteDefinition> toBeRemoved = new ArrayList<RouteDefinition>();
        for (RouteDefinition rd : this.model.getRouteDefinitions()) {
            if (rd.isTemplate() == null || !rd.isTemplate().booleanValue()) continue;
            toBeRemoved.add(rd);
        }
        this.removeRouteDefinitions(toBeRemoved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRouteDefinitions(List<RouteDefinition> routeDefinitions) throws Exception {
        boolean alreadyStartingRoutes = this.isStartingRoutes();
        if (!alreadyStartingRoutes) {
            this.setStartingRoutes(true);
        }
        PropertiesComponent pc = this.getCamelContextReference().getPropertiesComponent();
        LocalBeanRepositoryAware localBeans = null;
        Registry registry = this.getCamelContextReference().getRegistry();
        if (registry instanceof LocalBeanRepositoryAware) {
            LocalBeanRepositoryAware localBeanRepositoryAware;
            localBeans = localBeanRepositoryAware = (LocalBeanRepositoryAware)((Object)registry);
        }
        try {
            RouteDefinitionHelper.forceAssignIds(this.getCamelContextReference(), routeDefinitions);
            ArrayList<RouteDefinition> routeDefinitionsToRemove = null;
            for (RouteDefinition routeDefinition : routeDefinitions) {
                String duplicate = RouteDefinitionHelper.validateUniqueIds(routeDefinition, routeDefinitions, routeDefinition.getNodePrefixId());
                if (duplicate != null) {
                    throw new FailedToStartRouteException(routeDefinition.getId(), "duplicate id detected: " + duplicate + ". Please correct ids to be unique among all your routes.");
                }
                if (routeDefinition.isTemplate() != null && routeDefinition.isTemplate().booleanValue() && routeDefinition.getTemplateParameters() != null) {
                    if (routeDefinition.getRouteTemplateContext().getConfigurer() != null) {
                        routeDefinition.getRouteTemplateContext().getConfigurer().accept(routeDefinition.getRouteTemplateContext());
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>(routeDefinition.getTemplateParameters());
                    LocalBeanRegistry bbr = (LocalBeanRegistry)routeDefinition.getRouteTemplateContext().getLocalBeanRepository();
                    LocalBeanRegistry bbrCopy = new LocalBeanRegistry();
                    if (bbr != null && !bbr.isEmpty()) {
                        for (Map.Entry entry : params.entrySet()) {
                            Object value = entry.getValue();
                            if (!(value instanceof String)) continue;
                            String oldKey = (String)value;
                            boolean clash = bbr.keys().stream().anyMatch(k -> k.equals(oldKey));
                            if (!clash) continue;
                            String newKey = oldKey + "-" + UUID.generateUuid();
                            LOG.debug("Route: {} re-assigning local-bean id: {} to: {} to ensure ids are globally unique", new Object[]{routeDefinition.getId(), oldKey, newKey});
                            bbrCopy.put(newKey, (Map)bbr.remove(oldKey));
                            entry.setValue((CallSite)((Object)newKey));
                        }
                        for (Map.Entry entry : bbr.entrySet()) {
                            String oldKey = (String)entry.getKey();
                            String newKey = oldKey + "-" + UUID.generateUuid();
                            LOG.debug("Route: {} re-assigning local-bean id: {} to: {} to ensure ids are globally unique", new Object[]{routeDefinition.getId(), oldKey, newKey});
                            bbrCopy.put(newKey, (Map)entry.getValue());
                            if (params.containsKey(oldKey)) continue;
                            params.put(oldKey, newKey);
                        }
                    }
                    OrderedLocationProperties prop = new OrderedLocationProperties();
                    if (routeDefinition.getTemplateDefaultParameters() != null) {
                        params.forEach((k, v) -> {
                            Object dv = routeDefinition.getTemplateDefaultParameters().get(k);
                            prop.put(routeDefinition.getLocation(), k, v, dv);
                        });
                    } else {
                        prop.putAll(routeDefinition.getLocation(), params);
                    }
                    pc.setLocalProperties(prop);
                    if (localBeans != null) {
                        localBeans.setLocalBeanRepository(bbrCopy);
                    }
                    ProcessorDefinitionHelper.resetAllAutoAssignedNodeIds(routeDefinition);
                    RouteDefinitionHelper.initParent(routeDefinition);
                }
                if (this.includedRoute(routeDefinition)) {
                    if (!routeDefinition.isPrepared()) {
                        RouteDefinitionHelper.prepareRoute(this.getCamelContextReference(), routeDefinition);
                        routeDefinition.markPrepared();
                    }
                    RouteDefinitionHelper.forceAssignIds((CamelContext)this, routeDefinition.getInput());
                    RouteDefinitionHelper.forceAssignIds((CamelContext)this, routeDefinition);
                    StartupStepRecorder recorder = this.getCamelContextReference().getCamelContextExtension().getStartupStepRecorder();
                    StartupStep step = recorder.beginStep(Route.class, routeDefinition.getRouteId(), "Create Route");
                    Route route = this.model.getModelReifierFactory().createRoute(this, routeDefinition);
                    recorder.endStep(step);
                    RouteService routeService = new RouteService(route);
                    this.startRouteService(routeService, true);
                } else {
                    if (routeDefinitionsToRemove == null) {
                        routeDefinitionsToRemove = new ArrayList<RouteDefinition>(routeDefinitions.size());
                    }
                    routeDefinitionsToRemove.add(routeDefinition);
                }
                pc.setLocalProperties(null);
                if (localBeans == null) continue;
                localBeans.setLocalBeanRepository(null);
            }
            if (routeDefinitionsToRemove != null) {
                this.model.removeRouteDefinitions(routeDefinitionsToRemove);
            }
        }
        finally {
            if (!alreadyStartingRoutes) {
                this.setStartingRoutes(false);
            }
            pc.setLocalProperties(null);
            if (localBeans != null) {
                localBeans.setLocalBeanRepository(null);
            }
        }
    }

    @Override
    protected ExecutorServiceManager createExecutorServiceManager() {
        return new DefaultExecutorServiceManager(this);
    }

    @Override
    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        return this.model.getModelReifierFactory().createErrorHandler(route, processor);
    }

    @Override
    public Expression createExpression(ExpressionDefinition definition) {
        return this.model.getModelReifierFactory().createExpression(this, definition);
    }

    @Override
    public Predicate createPredicate(ExpressionDefinition definition) {
        return this.model.getModelReifierFactory().createPredicate(this, definition);
    }

    @Override
    public void registerValidator(ValidatorDefinition def) {
        this.model.getValidators().add(def);
        Validator validator = this.model.getModelReifierFactory().createValidator(this, def);
        this.getValidatorRegistry().put(DefaultCamelContext.createValidatorKey(def), validator);
    }

    private static ValidatorKey createValidatorKey(ValidatorDefinition def) {
        return new ValidatorKey(new DataType(def.getType()));
    }

    @Override
    public void registerTransformer(TransformerDefinition def) {
        this.model.getTransformers().add(def);
        Transformer transformer = this.model.getModelReifierFactory().createTransformer(this, def);
        this.getTransformerRegistry().put(DefaultCamelContext.createTransformerKey(def), transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeRoute(String routeId, LoggingLevel loggingLevel) throws Exception {
        Model model = this.model;
        synchronized (model) {
            boolean bl;
            this.getLock().lock();
            try {
                RouteDefinition def;
                boolean removed = super.removeRoute(routeId, loggingLevel);
                if (removed && (def = this.getRouteDefinition(routeId)) != null) {
                    this.removeRouteDefinition(def);
                }
                bl = removed;
                this.getLock().unlock();
            }
            catch (Throwable throwable) {
                this.getLock().unlock();
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRoute(String routeId) throws Exception {
        Model model = this.model;
        synchronized (model) {
            return super.removeRoute(routeId);
        }
    }

    private boolean includedRoute(RouteDefinition definition) {
        return PreconditionHelper.included(definition, this);
    }

    private static TransformerKey createTransformerKey(TransformerDefinition def) {
        if (ObjectHelper.isNotEmpty(def.getScheme())) {
            return ObjectHelper.isNotEmpty(def.getName()) ? new TransformerKey(def.getScheme() + ":" + def.getName()) : new TransformerKey(def.getScheme());
        }
        if (ObjectHelper.isNotEmpty(def.getName())) {
            return new TransformerKey(def.getName());
        }
        return new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }

    protected ModelReifierFactory createModelReifierFactory() {
        Optional<ModelReifierFactory> result = ResolverHelper.resolveService((CamelContext)this, this.getCamelContextExtension().getBootstrapFactoryFinder(), "model-reifier-factory", ModelReifierFactory.class);
        return result.orElseGet(DefaultModelReifierFactory::new);
    }
}

