/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.LineNumberAware;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.reifier.ToDynamicReifier;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.StringHelper;

public class WireTapReifier
extends ToDynamicReifier<WireTapDefinition<?>> {
    public WireTapReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        if (((WireTapDefinition)this.definition).getVariableReceive() != null) {
            throw new IllegalArgumentException("WireTap does not support variableReceive");
        }
        ((WireTapDefinition)this.definition).setPattern(ExchangePattern.InOnly.name());
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ExecutorService threadPool = this.getConfiguredExecutorService("WireTap", (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        String uri = ((WireTapDefinition)this.definition).getEndpointProducerBuilder() != null ? ((WireTapDefinition)this.definition).getEndpointProducerBuilder().getRawUri() : StringHelper.notEmpty(((WireTapDefinition)this.definition).getUri(), "uri", this);
        RouteDefinition rd = ProcessorDefinitionHelper.getRoute(this.definition);
        if (rd != null && rd.isTemplate() != null && rd.isTemplate().booleanValue()) {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this.camelContext, uri);
        }
        SendDynamicProcessor dynamicSendProcessor = null;
        SendProcessor sendProcessor = null;
        boolean simple = LanguageSupport.hasSimpleFunction(uri);
        boolean dynamic = this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true);
        boolean invalid = this.parseBoolean(((WireTapDefinition)this.definition).getIgnoreInvalidEndpoint(), false);
        if (dynamic && simple || invalid) {
            dynamicSendProcessor = (SendDynamicProcessor)super.createProcessor();
        } else {
            Endpoint endpoint = CamelContextHelper.resolveEndpoint(this.camelContext, uri, null);
            LineNumberAware.trySetLineNumberAware(endpoint, this.definition);
            sendProcessor = new SendProcessor(endpoint);
            sendProcessor.setVariableSend(this.parseString(((WireTapDefinition)this.definition).getVariableSend()));
            sendProcessor.setVariableReceive(this.parseString(((WireTapDefinition)this.definition).getVariableReceive()));
        }
        SendDynamicProcessor producer = dynamicSendProcessor != null ? dynamicSendProcessor : sendProcessor;
        Processor childProcessor = this.wrapInErrorHandler(producer);
        InternalProcessor target = PluginHelper.getInternalProcessorFactory(this.camelContext).addUnitOfWorkProcessorAdvice(this.camelContext, childProcessor, this.route);
        boolean isCopy = this.parseBoolean(((WireTapDefinition)this.definition).getCopy(), true);
        WireTapProcessor answer = new WireTapProcessor(dynamicSendProcessor, target, uri, this.parse(ExchangePattern.class, ((WireTapDefinition)this.definition).getPattern()), isCopy, threadPool, shutdownThreadPool, dynamic);
        Processor prepare = ((WireTapDefinition)this.definition).getOnPrepareProcessor();
        if (prepare == null && ((WireTapDefinition)this.definition).getOnPrepare() != null) {
            prepare = this.mandatoryLookup(((WireTapDefinition)this.definition).getOnPrepare(), Processor.class);
        }
        answer.setOnPrepare(prepare);
        return answer;
    }

    @Override
    protected Expression createExpression(String uri) {
        if (this.parseBoolean(((WireTapDefinition)this.definition).getDynamicUri(), true)) {
            return super.createExpression(uri);
        }
        return this.camelContext.resolveLanguage("constant").createExpression(uri);
    }
}

