/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.kiwiproject.consul.model.acl.ImmutableNodeIdentity;
import org.kiwiproject.consul.model.acl.ImmutablePolicyLink;
import org.kiwiproject.consul.model.acl.ImmutableRoleLink;
import org.kiwiproject.consul.model.acl.ImmutableServiceIdentity;
import org.kiwiproject.consul.model.acl.ImmutableToken;

@JsonSerialize(as=ImmutableToken.class)
@JsonDeserialize(as=ImmutableToken.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(jakarta=true)
public abstract class Token {
    @JsonProperty(value="AccessorID")
    public abstract Optional<String> id();

    @JsonProperty(value="SecretID")
    public abstract Optional<String> secretId();

    @JsonProperty(value="Description")
    public abstract Optional<String> description();

    @JsonProperty(value="Policies")
    @JsonDeserialize(as=ImmutableList.class, contentAs=PolicyLink.class)
    public abstract List<PolicyLink> policies();

    @JsonProperty(value="Roles")
    @JsonDeserialize(as=ImmutableList.class, contentAs=RoleLink.class)
    public abstract List<RoleLink> roles();

    @JsonProperty(value="ServiceIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=ServiceIdentity.class)
    public abstract List<ServiceIdentity> serviceIdentities();

    @JsonProperty(value="NodeIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=NodeIdentity.class)
    public abstract List<NodeIdentity> nodeIdentities();

    @JsonProperty(value="Local")
    public abstract Optional<Boolean> local();

    @JsonProperty(value="ExpirationTime")
    public abstract Optional<String> expirationTime();

    @JsonProperty(value="ExpirationTTL")
    public abstract Optional<String> expirationTTL();

    @JsonProperty(value="Namespace")
    public abstract Optional<String> namespace();

    @JsonSerialize(as=ImmutableNodeIdentity.class)
    @JsonDeserialize(as=ImmutableNodeIdentity.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class NodeIdentity {
        @JsonProperty(value="NodeName")
        public abstract String name();

        @JsonProperty(value="Datacenter")
        public abstract String datacenter();
    }

    @JsonSerialize(as=ImmutableServiceIdentity.class)
    @JsonDeserialize(as=ImmutableServiceIdentity.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class ServiceIdentity {
        @JsonProperty(value="ServiceName")
        public abstract String name();

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public abstract List<String> datacenters();
    }

    @JsonSerialize(as=ImmutableRoleLink.class)
    @JsonDeserialize(as=ImmutableRoleLink.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RoleLink {
        @JsonProperty(value="ID")
        public abstract Optional<String> id();

        @JsonProperty(value="Name")
        public abstract Optional<String> name();
    }

    @JsonSerialize(as=ImmutablePolicyLink.class)
    @JsonDeserialize(as=ImmutablePolicyLink.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class PolicyLink {
        @JsonProperty(value="ID")
        public abstract Optional<String> id();

        @JsonProperty(value="Name")
        public abstract Optional<String> name();
    }
}

