/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.agent.ServiceProxy;
import org.kiwiproject.consul.model.agent.ServiceProxyUpstream;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceProxy", generator="Immutables")
public final class ImmutableServiceProxy
extends ServiceProxy {
    private final String destinationServiceName;
    private final String destinationServiceId;
    private final String localServiceAddress;
    private final int localServicePort;
    private final ImmutableMap<String, String> config;
    private final ImmutableList<ServiceProxyUpstream> upstreams;

    private ImmutableServiceProxy(String destinationServiceName, String destinationServiceId, String localServiceAddress, int localServicePort, ImmutableMap<String, String> config, ImmutableList<ServiceProxyUpstream> upstreams) {
        this.destinationServiceName = destinationServiceName;
        this.destinationServiceId = destinationServiceId;
        this.localServiceAddress = localServiceAddress;
        this.localServicePort = localServicePort;
        this.config = config;
        this.upstreams = upstreams;
    }

    @Override
    @JsonProperty(value="DestinationServiceName")
    public String getDestinationServiceName() {
        return this.destinationServiceName;
    }

    @Override
    @JsonProperty(value="DestinationServiceID")
    public String getDestinationServiceId() {
        return this.destinationServiceId;
    }

    @Override
    @JsonProperty(value="LocalServiceAddress")
    public String getLocalServiceAddress() {
        return this.localServiceAddress;
    }

    @Override
    @JsonProperty(value="LocalServicePort")
    public int getLocalServicePort() {
        return this.localServicePort;
    }

    @JsonProperty(value="Config")
    public ImmutableMap<String, String> getConfig() {
        return this.config;
    }

    @JsonProperty(value="Upstreams")
    @JsonDeserialize(as=ImmutableList.class, contentAs=ServiceProxyUpstream.class)
    public ImmutableList<ServiceProxyUpstream> getUpstreams() {
        return this.upstreams;
    }

    public final ImmutableServiceProxy withDestinationServiceName(String value) {
        String newValue = Objects.requireNonNull(value, "destinationServiceName");
        if (this.destinationServiceName.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceProxy(newValue, this.destinationServiceId, this.localServiceAddress, this.localServicePort, this.config, this.upstreams);
    }

    public final ImmutableServiceProxy withDestinationServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "destinationServiceId");
        if (this.destinationServiceId.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceProxy(this.destinationServiceName, newValue, this.localServiceAddress, this.localServicePort, this.config, this.upstreams);
    }

    public final ImmutableServiceProxy withLocalServiceAddress(String value) {
        String newValue = Objects.requireNonNull(value, "localServiceAddress");
        if (this.localServiceAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceProxy(this.destinationServiceName, this.destinationServiceId, newValue, this.localServicePort, this.config, this.upstreams);
    }

    public final ImmutableServiceProxy withLocalServicePort(int value) {
        if (this.localServicePort == value) {
            return this;
        }
        return new ImmutableServiceProxy(this.destinationServiceName, this.destinationServiceId, this.localServiceAddress, value, this.config, this.upstreams);
    }

    public final ImmutableServiceProxy withConfig(Map<String, ? extends String> entries) {
        if (this.config == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableServiceProxy(this.destinationServiceName, this.destinationServiceId, this.localServiceAddress, this.localServicePort, newValue, this.upstreams);
    }

    public final ImmutableServiceProxy withUpstreams(ServiceProxyUpstream ... elements) {
        ImmutableList<ServiceProxyUpstream> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceProxy(this.destinationServiceName, this.destinationServiceId, this.localServiceAddress, this.localServicePort, this.config, newValue);
    }

    public final ImmutableServiceProxy withUpstreams(Iterable<? extends ServiceProxyUpstream> elements) {
        if (this.upstreams == elements) {
            return this;
        }
        ImmutableList<ServiceProxyUpstream> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceProxy(this.destinationServiceName, this.destinationServiceId, this.localServiceAddress, this.localServicePort, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceProxy && this.equalTo(0, (ImmutableServiceProxy)another);
    }

    private boolean equalTo(int synthetic, ImmutableServiceProxy another) {
        return this.destinationServiceName.equals(another.destinationServiceName) && this.destinationServiceId.equals(another.destinationServiceId) && this.localServiceAddress.equals(another.localServiceAddress) && this.localServicePort == another.localServicePort && this.config.equals(another.config) && this.upstreams.equals(another.upstreams);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.destinationServiceName.hashCode();
        h2 += (h2 << 5) + this.destinationServiceId.hashCode();
        h2 += (h2 << 5) + this.localServiceAddress.hashCode();
        h2 += (h2 << 5) + this.localServicePort;
        h2 += (h2 << 5) + this.config.hashCode();
        h2 += (h2 << 5) + this.upstreams.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceProxy").omitNullValues().add("destinationServiceName", this.destinationServiceName).add("destinationServiceId", this.destinationServiceId).add("localServiceAddress", this.localServiceAddress).add("localServicePort", this.localServicePort).add("config", this.config).add("upstreams", this.upstreams).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceProxy fromJson(Json json) {
        Builder builder = ImmutableServiceProxy.builder();
        if (json.destinationServiceName != null) {
            builder.destinationServiceName(json.destinationServiceName);
        }
        if (json.destinationServiceId != null) {
            builder.destinationServiceId(json.destinationServiceId);
        }
        if (json.localServiceAddress != null) {
            builder.localServiceAddress(json.localServiceAddress);
        }
        if (json.localServicePortIsSet) {
            builder.localServicePort(json.localServicePort);
        }
        if (json.config != null) {
            builder.putAllConfig(json.config);
        }
        if (json.upstreams != null) {
            builder.addAllUpstreams(json.upstreams);
        }
        return builder.build();
    }

    public static ImmutableServiceProxy copyOf(ServiceProxy instance) {
        if (instance instanceof ImmutableServiceProxy) {
            return (ImmutableServiceProxy)instance;
        }
        return ImmutableServiceProxy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceProxy", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DESTINATION_SERVICE_NAME = 1L;
        private static final long INIT_BIT_DESTINATION_SERVICE_ID = 2L;
        private static final long INIT_BIT_LOCAL_SERVICE_ADDRESS = 4L;
        private static final long INIT_BIT_LOCAL_SERVICE_PORT = 8L;
        private long initBits = 15L;
        @Nullable
        private String destinationServiceName;
        @Nullable
        private String destinationServiceId;
        @Nullable
        private String localServiceAddress;
        private int localServicePort;
        private ImmutableMap.Builder<String, String> config = ImmutableMap.builder();
        private ImmutableList.Builder<ServiceProxyUpstream> upstreams = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceProxy instance) {
            Objects.requireNonNull(instance, "instance");
            this.destinationServiceName(instance.getDestinationServiceName());
            this.destinationServiceId(instance.getDestinationServiceId());
            this.localServiceAddress(instance.getLocalServiceAddress());
            this.localServicePort(instance.getLocalServicePort());
            this.putAllConfig(instance.getConfig());
            this.addAllUpstreams(instance.getUpstreams());
            return this;
        }

        @JsonProperty(value="DestinationServiceName")
        @CanIgnoreReturnValue
        public final Builder destinationServiceName(String destinationServiceName) {
            this.destinationServiceName = Objects.requireNonNull(destinationServiceName, "destinationServiceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="DestinationServiceID")
        @CanIgnoreReturnValue
        public final Builder destinationServiceId(String destinationServiceId) {
            this.destinationServiceId = Objects.requireNonNull(destinationServiceId, "destinationServiceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="LocalServiceAddress")
        @CanIgnoreReturnValue
        public final Builder localServiceAddress(String localServiceAddress) {
            this.localServiceAddress = Objects.requireNonNull(localServiceAddress, "localServiceAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="LocalServicePort")
        @CanIgnoreReturnValue
        public final Builder localServicePort(int localServicePort) {
            this.localServicePort = localServicePort;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
            this.config.put(entry);
            return this;
        }

        @JsonProperty(value="Config")
        @CanIgnoreReturnValue
        public final Builder config(Map<String, ? extends String> entries) {
            this.config = ImmutableMap.builder();
            return this.putAllConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConfig(Map<String, ? extends String> entries) {
            this.config.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpstreams(ServiceProxyUpstream element) {
            this.upstreams.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpstreams(ServiceProxyUpstream ... elements) {
            this.upstreams.add(elements);
            return this;
        }

        @JsonProperty(value="Upstreams")
        @JsonDeserialize(as=ImmutableList.class, contentAs=ServiceProxyUpstream.class)
        @CanIgnoreReturnValue
        public final Builder upstreams(Iterable<? extends ServiceProxyUpstream> elements) {
            this.upstreams = ImmutableList.builder();
            return this.addAllUpstreams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUpstreams(Iterable<? extends ServiceProxyUpstream> elements) {
            this.upstreams.addAll(elements);
            return this;
        }

        public ImmutableServiceProxy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceProxy(this.destinationServiceName, this.destinationServiceId, this.localServiceAddress, this.localServicePort, this.config.build(), (ImmutableList<ServiceProxyUpstream>)this.upstreams.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destinationServiceName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destinationServiceId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("localServiceAddress");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("localServicePort");
            }
            return "Cannot build ServiceProxy, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServiceProxy", generator="Immutables")
    static final class Json
    extends ServiceProxy {
        @Nullable
        String destinationServiceName;
        @Nullable
        String destinationServiceId;
        @Nullable
        String localServiceAddress;
        int localServicePort;
        boolean localServicePortIsSet;
        @Nullable
        Map<String, String> config = ImmutableMap.of();
        @Nullable
        List<ServiceProxyUpstream> upstreams = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="DestinationServiceName")
        public void setDestinationServiceName(String destinationServiceName) {
            this.destinationServiceName = destinationServiceName;
        }

        @JsonProperty(value="DestinationServiceID")
        public void setDestinationServiceId(String destinationServiceId) {
            this.destinationServiceId = destinationServiceId;
        }

        @JsonProperty(value="LocalServiceAddress")
        public void setLocalServiceAddress(String localServiceAddress) {
            this.localServiceAddress = localServiceAddress;
        }

        @JsonProperty(value="LocalServicePort")
        public void setLocalServicePort(int localServicePort) {
            this.localServicePort = localServicePort;
            this.localServicePortIsSet = true;
        }

        @JsonProperty(value="Config")
        public void setConfig(Map<String, String> config) {
            this.config = config;
        }

        @JsonProperty(value="Upstreams")
        @JsonDeserialize(as=ImmutableList.class, contentAs=ServiceProxyUpstream.class)
        public void setUpstreams(List<ServiceProxyUpstream> upstreams) {
            this.upstreams = upstreams;
        }

        @Override
        public String getDestinationServiceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDestinationServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocalServiceAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLocalServicePort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ServiceProxyUpstream> getUpstreams() {
            throw new UnsupportedOperationException();
        }
    }
}

