/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.cloud;

import java.time.Duration;
import org.apache.camel.CamelContext;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryFactory;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.cloud.ConsulServiceDiscovery;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.CloudServiceFactory;
import org.apache.camel.support.jsse.SSLContextParameters;

@CloudServiceFactory(value="consul-service-discovery")
@Configurer
public class ConsulServiceDiscoveryFactory
implements ServiceDiscoveryFactory {
    private final ConsulConfiguration configuration;

    public ConsulServiceDiscoveryFactory() {
        this(new ConsulConfiguration());
    }

    public ConsulServiceDiscoveryFactory(ConsulConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getUrl() {
        return this.configuration.getUrl();
    }

    public void setUrl(String url) {
        this.configuration.setUrl(url);
    }

    public void setDatacenter(String dc) {
        this.configuration.setDatacenter(dc);
    }

    public String getDatacenter() {
        return this.configuration.getDatacenter();
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public String getAclToken() {
        return this.configuration.getAclToken();
    }

    public void setAclToken(String aclToken) {
        this.configuration.setAclToken(aclToken);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public Duration getConnectTimeout() {
        return this.configuration.getConnectTimeout();
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.configuration.setConnectTimeout(connectTimeout);
    }

    public Duration getReadTimeout() {
        return this.configuration.getReadTimeout();
    }

    public void setReadTimeout(Duration readTimeout) {
        this.configuration.setReadTimeout(readTimeout);
    }

    public Duration getWriteTimeout() {
        return this.configuration.getWriteTimeout();
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.configuration.setWriteTimeout(writeTimeout);
    }

    public Integer getBlockSeconds() {
        return this.configuration.getBlockSeconds();
    }

    public void setBlockSeconds(Integer blockSeconds) {
        this.configuration.setBlockSeconds(blockSeconds);
    }

    @Override
    public ServiceDiscovery newInstance(CamelContext camelContext) throws Exception {
        return new ConsulServiceDiscovery(this.configuration);
    }
}

