/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.camel.Processor;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.kiwiproject.consul.Consul;

abstract class AbstractConsulConsumer<C>
extends DefaultConsumer {
    protected final ConsulEndpoint endpoint;
    protected final ConsulConfiguration configuration;
    protected final String key;
    protected final AtomicReference<BigInteger> index;
    private final Function<Consul, C> clientSupplier;
    private Runnable watcher;

    protected AbstractConsulConsumer(ConsulEndpoint endpoint, ConsulConfiguration configuration, Processor processor, Function<Consul, C> clientSupplier) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.key = ObjectHelper.notNull(configuration.getKey(), "CamelConsulKey");
        this.index = new AtomicReference<BigInteger>(configuration.getFirstIndex());
        this.clientSupplier = clientSupplier;
        this.watcher = null;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.watcher = this.createWatcher(this.clientSupplier.apply(this.endpoint.getConsul()));
        this.watcher.run();
    }

    @Override
    protected void doStop() throws Exception {
        this.watcher = null;
        super.doStop();
    }

    protected abstract Runnable createWatcher(C var1) throws Exception;

    protected abstract class AbstractWatcher
    implements Runnable {
        private final C client;

        protected AbstractWatcher(C client) {
            this.client = client;
        }

        protected void onError(Throwable throwable) {
            if (AbstractConsulConsumer.this.isRunAllowed()) {
                AbstractConsulConsumer.this.getExceptionHandler().handleException("Error watching for event " + AbstractConsulConsumer.this.key, throwable);
            }
        }

        protected final void setIndex(BigInteger responseIndex) {
            AbstractConsulConsumer.this.index.set(responseIndex);
        }

        @Override
        public final void run() {
            if (AbstractConsulConsumer.this.isRunAllowed()) {
                this.watch(this.client);
            }
        }

        protected final C client() {
            return this.client;
        }

        protected final void watch() {
            this.watch(this.client);
        }

        protected abstract void watch(C var1);
    }
}

