/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import org.apache.camel.Message;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.component.consul.endpoint.AbstractConsulProducer;
import org.apache.camel.spi.InvokeOnHeader;
import org.kiwiproject.consul.CatalogClient;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.model.catalog.CatalogDeregistration;
import org.kiwiproject.consul.model.catalog.CatalogRegistration;

public final class ConsulCatalogProducer
extends AbstractConsulProducer<CatalogClient> {
    public ConsulCatalogProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration) {
        super(endpoint, configuration, Consul::catalogClient);
    }

    @InvokeOnHeader(value="REGISTER")
    protected void register(Message message) throws Exception {
        ((CatalogClient)this.getClient()).register(message.getMandatoryBody(CatalogRegistration.class));
        this.setBodyAndResult(message, null);
    }

    @InvokeOnHeader(value="DEREGISTER")
    protected void deregister(Message message) throws Exception {
        ((CatalogClient)this.getClient()).deregister(message.getMandatoryBody(CatalogDeregistration.class));
        this.setBodyAndResult(message, null);
    }

    @InvokeOnHeader(value="LIST_DATACENTERS")
    protected void listDatacenters(Message message) throws Exception {
        this.setBodyAndResult(message, ((CatalogClient)this.getClient()).getDatacenters());
    }

    @InvokeOnHeader(value="LIST_NODES")
    protected void listNodes(Message message) throws Exception {
        this.processConsulResponse(message, ((CatalogClient)this.getClient()).getNodes(this.buildQueryOptions(message, this.getConfiguration())));
    }

    @InvokeOnHeader(value="LIST_SERVICES")
    protected void listServices(Message message) throws Exception {
        this.processConsulResponse(message, ((CatalogClient)this.getClient()).getServices(this.buildQueryOptions(message, this.getConfiguration())));
    }

    @InvokeOnHeader(value="GET_SERVICE")
    protected void getService(Message message) throws Exception {
        this.processConsulResponse(message, ((CatalogClient)this.getClient()).getService(this.getMandatoryHeader(message, "CamelConsulService", String.class), this.buildQueryOptions(message, this.getConfiguration())));
    }

    @InvokeOnHeader(value="GET_NODE")
    protected void getNode(Message message) throws Exception {
        this.processConsulResponse(message, ((CatalogClient)this.getClient()).getNode(this.getMandatoryHeader(message, "CamelConsulNode", String.class), this.buildQueryOptions(message, this.getConfiguration())));
    }
}

