/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesFunctionResolver;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spi.ConfigurerStrategy;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class PropertiesComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        PropertiesComponent target = (PropertiesComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autodiscoverpropertiessources": 
            case "autoDiscoverPropertiesSources": {
                target.setAutoDiscoverPropertiesSources(PropertiesComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "camelcontext": 
            case "camelContext": {
                target.setCamelContext(PropertiesComponentConfigurer.property(camelContext, CamelContext.class, value));
                return true;
            }
            case "defaultfallbackenabled": 
            case "defaultFallbackEnabled": {
                target.setDefaultFallbackEnabled(PropertiesComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "encoding": {
                target.setEncoding(PropertiesComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "environmentvariablemode": 
            case "environmentVariableMode": {
                target.setEnvironmentVariableMode(PropertiesComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "ignoremissinglocation": 
            case "ignoreMissingLocation": {
                target.setIgnoreMissingLocation(PropertiesComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "ignoremissingproperty": 
            case "ignoreMissingProperty": {
                target.setIgnoreMissingProperty(PropertiesComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "initialproperties": 
            case "initialProperties": {
                target.setInitialProperties(PropertiesComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "localproperties": 
            case "localProperties": {
                target.setLocalProperties(PropertiesComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "location": {
                target.setLocation(PropertiesComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "locations": {
                target.setLocations(PropertiesComponentConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "nestedplaceholder": 
            case "nestedPlaceholder": {
                target.setNestedPlaceholder(PropertiesComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "overrideproperties": 
            case "overrideProperties": {
                target.setOverrideProperties(PropertiesComponentConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "propertiesfunctionresolver": 
            case "propertiesFunctionResolver": {
                target.setPropertiesFunctionResolver(PropertiesComponentConfigurer.property(camelContext, PropertiesFunctionResolver.class, value));
                return true;
            }
            case "propertiesparser": 
            case "propertiesParser": {
                target.setPropertiesParser(PropertiesComponentConfigurer.property(camelContext, PropertiesParser.class, value));
                return true;
            }
            case "systempropertiesmode": 
            case "systemPropertiesMode": {
                target.setSystemPropertiesMode(PropertiesComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public static void clearBootstrapConfigurers() {
        ALL_OPTIONS.clear();
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autodiscoverpropertiessources": 
            case "autoDiscoverPropertiesSources": {
                return Boolean.TYPE;
            }
            case "camelcontext": 
            case "camelContext": {
                return CamelContext.class;
            }
            case "defaultfallbackenabled": 
            case "defaultFallbackEnabled": {
                return Boolean.TYPE;
            }
            case "encoding": {
                return String.class;
            }
            case "environmentvariablemode": 
            case "environmentVariableMode": {
                return Integer.TYPE;
            }
            case "ignoremissinglocation": 
            case "ignoreMissingLocation": {
                return Boolean.TYPE;
            }
            case "ignoremissingproperty": 
            case "ignoreMissingProperty": {
                return Boolean.TYPE;
            }
            case "initialproperties": 
            case "initialProperties": {
                return Properties.class;
            }
            case "localproperties": 
            case "localProperties": {
                return Properties.class;
            }
            case "location": {
                return String.class;
            }
            case "locations": {
                return List.class;
            }
            case "nestedplaceholder": 
            case "nestedPlaceholder": {
                return Boolean.TYPE;
            }
            case "overrideproperties": 
            case "overrideProperties": {
                return Properties.class;
            }
            case "propertiesfunctionresolver": 
            case "propertiesFunctionResolver": {
                return PropertiesFunctionResolver.class;
            }
            case "propertiesparser": 
            case "propertiesParser": {
                return PropertiesParser.class;
            }
            case "systempropertiesmode": 
            case "systemPropertiesMode": {
                return Integer.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        PropertiesComponent target = (PropertiesComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autodiscoverpropertiessources": 
            case "autoDiscoverPropertiesSources": {
                return target.isAutoDiscoverPropertiesSources();
            }
            case "camelcontext": 
            case "camelContext": {
                return target.getCamelContext();
            }
            case "defaultfallbackenabled": 
            case "defaultFallbackEnabled": {
                return target.isDefaultFallbackEnabled();
            }
            case "encoding": {
                return target.getEncoding();
            }
            case "environmentvariablemode": 
            case "environmentVariableMode": {
                return target.getEnvironmentVariableMode();
            }
            case "ignoremissinglocation": 
            case "ignoreMissingLocation": {
                return target.isIgnoreMissingLocation();
            }
            case "ignoremissingproperty": 
            case "ignoreMissingProperty": {
                return target.isIgnoreMissingProperty();
            }
            case "initialproperties": 
            case "initialProperties": {
                return target.getInitialProperties();
            }
            case "localproperties": 
            case "localProperties": {
                return target.getLocalProperties();
            }
            case "location": {
                return target.getLocation();
            }
            case "locations": {
                return target.getLocations();
            }
            case "nestedplaceholder": 
            case "nestedPlaceholder": {
                return target.isNestedPlaceholder();
            }
            case "overrideproperties": 
            case "overrideProperties": {
                return target.getOverrideProperties();
            }
            case "propertiesfunctionresolver": 
            case "propertiesFunctionResolver": {
                return target.getPropertiesFunctionResolver();
            }
            case "propertiesparser": 
            case "propertiesParser": {
                return target.getPropertiesParser();
            }
            case "systempropertiesmode": 
            case "systemPropertiesMode": {
                return target.getSystemPropertiesMode();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "locations": {
                return PropertiesLocation.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("AutoDiscoverPropertiesSources", Boolean.TYPE);
        map.put("CamelContext", CamelContext.class);
        map.put("DefaultFallbackEnabled", Boolean.TYPE);
        map.put("Encoding", String.class);
        map.put("EnvironmentVariableMode", Integer.TYPE);
        map.put("IgnoreMissingLocation", Boolean.TYPE);
        map.put("IgnoreMissingProperty", Boolean.TYPE);
        map.put("InitialProperties", Properties.class);
        map.put("LocalProperties", Properties.class);
        map.put("Location", String.class);
        map.put("Locations", List.class);
        map.put("NestedPlaceholder", Boolean.TYPE);
        map.put("OverrideProperties", Properties.class);
        map.put("PropertiesFunctionResolver", PropertiesFunctionResolver.class);
        map.put("PropertiesParser", PropertiesParser.class);
        map.put("SystemPropertiesMode", Integer.TYPE);
        ALL_OPTIONS = map;
        ConfigurerStrategy.addBootstrapConfigurerClearer(PropertiesComponentConfigurer::clearBootstrapConfigurers);
    }
}

