/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.spi.TypeConverterRegistry;

public class CachingInjector<T> {
    private final TypeConverterRegistry repository;
    private final Class<T> type;
    private final Lock lock = new ReentrantLock();
    private T instance;

    public CachingInjector(TypeConverterRegistry repository, Class<T> type) {
        this.repository = repository;
        this.type = type;
    }

    public T newInstance() {
        this.lock.lock();
        try {
            if (this.instance == null) {
                this.instance = this.createInstance(this.type);
            }
            T t2 = this.instance;
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected T createInstance(Class<T> t2) {
        return this.repository.getInjector().newInstance(t2);
    }
}

