/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceSupport;

public class DefaultEndpointServiceRegistry
extends ServiceSupport
implements EndpointServiceRegistry {
    private final CamelContext camelContext;

    public DefaultEndpointServiceRegistry(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public List<EndpointServiceRegistry.EndpointService> listAllEndpointServices() {
        EndpointServiceRegistry.EndpointService es;
        ArrayList<EndpointServiceRegistry.EndpointService> answer = new ArrayList<EndpointServiceRegistry.EndpointService>();
        for (Route route : this.camelContext.getRoutes()) {
            EndpointServiceLocation esl;
            Consumer consumer = route.getConsumer();
            Endpoint endpoint = consumer.getEndpoint();
            if (!(endpoint instanceof EndpointServiceLocation) || (es = this.newEndpointService(endpoint, consumer, "in", esl = (EndpointServiceLocation)((Object)endpoint))) == null) continue;
            answer.add(es);
        }
        for (Endpoint endpoint : this.camelContext.getEndpointRegistry().getReadOnlyValues()) {
            if (!(endpoint instanceof EndpointServiceLocation)) continue;
            EndpointServiceLocation esl = (EndpointServiceLocation)((Object)endpoint);
            String component = endpoint.getComponent().getDefaultName();
            boolean skip = "platform-http".equals(component);
            if (skip || (es = this.newEndpointService(endpoint, null, "out", esl)) == null) continue;
            answer.add(es);
        }
        return answer;
    }

    private EndpointServiceRegistry.EndpointService newEndpointService(Endpoint endpoint, Consumer consumer, String dir, EndpointServiceLocation esl) {
        DefaultEndpointService answer = null;
        String adr = esl.getServiceUrl();
        if (adr != null) {
            String component = endpoint.getComponent().getDefaultName();
            boolean hosted = false;
            String routeId = null;
            if (consumer instanceof DefaultConsumer) {
                DefaultConsumer dc = (DefaultConsumer)consumer;
                hosted = dc.isHostedService();
                routeId = dc.getRouteId();
            }
            Optional<RuntimeEndpointRegistry.Statistic> stat = this.findStats(endpoint.getEndpointUri(), dir);
            long hits = 0L;
            if (stat.isPresent()) {
                RuntimeEndpointRegistry.Statistic s2 = stat.get();
                hits = s2.getHits();
                routeId = s2.getRouteId();
            }
            if ("out".equals(dir) && stat.isEmpty() && (stat = this.findStats(endpoint.getEndpointUri(), "in")).isPresent()) {
                return null;
            }
            answer = new DefaultEndpointService(component, endpoint.getEndpointUri(), adr, esl.getServiceProtocol(), esl.getServiceMetadata(), hosted, dir, hits, routeId);
        }
        return answer;
    }

    @Override
    public int size() {
        int size = 0;
        for (Endpoint e : this.camelContext.getEndpoints()) {
            if (!(e instanceof EndpointServiceLocation)) continue;
            ++size;
        }
        return size;
    }

    private Optional<RuntimeEndpointRegistry.Statistic> findStats(String uri, String direction) {
        if (this.camelContext.getRuntimeEndpointRegistry() == null) {
            return Optional.empty();
        }
        return this.camelContext.getRuntimeEndpointRegistry().getEndpointStatistics().stream().filter(s2 -> uri.equals(s2.getUri()) && (direction == null || s2.getDirection().equals(direction))).findFirst();
    }

    private static final class DefaultEndpointService
    implements EndpointServiceRegistry.EndpointService {
        private final String component;
        private final String endpointUri;
        private final String serviceUrl;
        private final String serviceProtocol;
        private final Map<String, String> serviceMetadata;
        private final boolean hostedService;
        private final String direction;
        private final long hits;
        private final String routeId;

        public DefaultEndpointService(String component, String endpointUri, String serviceUrl, String serviceProtocol, Map<String, String> serviceMetadata, boolean hostedService, String direction, long hits, String routeId) {
            this.component = component;
            this.endpointUri = endpointUri;
            this.serviceUrl = serviceUrl;
            this.serviceProtocol = serviceProtocol;
            this.serviceMetadata = serviceMetadata;
            this.hostedService = hostedService;
            this.direction = direction;
            this.hits = hits;
            this.routeId = routeId;
        }

        @Override
        public String getComponent() {
            return this.component;
        }

        @Override
        public String getEndpointUri() {
            return this.endpointUri;
        }

        @Override
        public String getServiceUrl() {
            return this.serviceUrl;
        }

        @Override
        public String getServiceProtocol() {
            return this.serviceProtocol;
        }

        @Override
        public Map<String, String> getServiceMetadata() {
            return this.serviceMetadata;
        }

        @Override
        public boolean isHostedService() {
            return this.hostedService;
        }

        @Override
        public String getDirection() {
            return this.direction;
        }

        @Override
        public long getHits() {
            return this.hits;
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }
    }
}

