/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.scan;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.util.ObjectHelper;

public class AnnotatedWithAnyPackageScanFilter
implements PackageScanFilter {
    private final Set<Class<? extends Annotation>> annotations;
    private final boolean checkMetaAnnotations;

    public AnnotatedWithAnyPackageScanFilter(Set<Class<? extends Annotation>> annotations) {
        this(annotations, false);
    }

    public AnnotatedWithAnyPackageScanFilter(Set<Class<? extends Annotation>> annotations, boolean checkMetaAnnotations) {
        this.annotations = annotations;
        this.checkMetaAnnotations = checkMetaAnnotations;
    }

    @Override
    public boolean matches(Class<?> type) {
        if (type == null) {
            return false;
        }
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (!ObjectHelper.hasAnnotation(type, annotation, this.checkMetaAnnotations)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "annotated with any @[" + String.valueOf(this.annotations) + "]";
    }
}

