/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="setHeaders")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SetHeadersDefinition
extends ProcessorDefinition<SetHeadersDefinition> {
    @XmlElementRef(name="headers")
    private List<SetHeaderDefinition> headers = new ArrayList<SetHeaderDefinition>();

    public SetHeadersDefinition() {
    }

    protected SetHeadersDefinition(SetHeadersDefinition source2) {
        super(source2);
        this.headers = ProcessorDefinitionHelper.deepCopyDefinitions(source2.headers);
    }

    @Override
    public SetHeadersDefinition copyDefinition() {
        return new SetHeadersDefinition(this);
    }

    public SetHeadersDefinition(Object ... headerNamesAndExprs) {
        this.createSetHeaderDefinitions(headerNamesAndExprs);
    }

    private void createSetHeaderDefinitions(Object[] headerNamesAndExprs) {
        if (headerNamesAndExprs.length == 1 && headerNamesAndExprs[0] instanceof Map) {
            this.createHeadersFromMap((Map)headerNamesAndExprs[0]);
        } else {
            if (headerNamesAndExprs.length % 2 != 0) {
                throw new IllegalArgumentException("Must be a Map or have an even number of arguments!");
            }
            for (int i = 0; i < headerNamesAndExprs.length; i += 2) {
                this.addHeader(headerNamesAndExprs[i], headerNamesAndExprs[i + 1]);
            }
        }
    }

    private void addHeader(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Keys must be Strings");
        }
        if (!(value instanceof Expression)) {
            value = ExpressionBuilder.constantExpression(value);
        }
        this.headers.add(new SetHeaderDefinition((String)key, (Expression)value));
    }

    private void createHeadersFromMap(Map<?, ?> headerMap) {
        for (Map.Entry<?, ?> entry : headerMap.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public List<SetHeaderDefinition> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<SetHeaderDefinition> headers) {
        this.headers = headers;
    }

    @Override
    public String getLabel() {
        return "setHeaders[" + this.getHeaderNames() + "]";
    }

    private String getHeaderNames() {
        StringJoiner sb = new StringJoiner(",");
        for (SetHeaderDefinition def : this.headers) {
            sb.add(def.getName());
        }
        return sb.toString();
    }

    @Override
    public String getShortName() {
        return "setHeaders";
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return Collections.emptyList();
    }
}

