/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.transformer;

import org.apache.camel.CamelContext;
import org.apache.camel.model.transformer.CustomTransformerDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.reifier.transformer.TransformerReifier;
import org.apache.camel.spi.Transformer;

public class CustomTransformerReifier
extends TransformerReifier<CustomTransformerDefinition> {
    public CustomTransformerReifier(CamelContext camelContext, TransformerDefinition definition) {
        super(camelContext, (CustomTransformerDefinition)definition);
    }

    @Override
    protected Transformer doCreateTransformer() {
        Transformer transformer;
        if (((CustomTransformerDefinition)this.definition).getRef() == null && ((CustomTransformerDefinition)this.definition).getClassName() == null) {
            throw new IllegalArgumentException("'ref' or 'className' must be specified for customTransformer");
        }
        String ref = this.parseString(((CustomTransformerDefinition)this.definition).getRef());
        if (ref != null) {
            transformer = this.lookupByNameAndType(ref, Transformer.class);
            if (transformer == null) {
                throw new IllegalArgumentException("Cannot find transformer with ref:" + ((CustomTransformerDefinition)this.definition).getRef());
            }
            if (transformer.getName() != null || transformer.getFrom() != null || transformer.getTo() != null) {
                throw new IllegalArgumentException(String.format("Transformer '%s' is already in use. Please check if duplicate transformer exists.", ((CustomTransformerDefinition)this.definition).getRef()));
            }
        } else {
            Class<Transformer> transformerClass = this.camelContext.getClassResolver().resolveClass(((CustomTransformerDefinition)this.definition).getClassName(), Transformer.class);
            if (transformerClass == null) {
                throw new IllegalArgumentException("Cannot find transformer class: " + ((CustomTransformerDefinition)this.definition).getClassName());
            }
            transformer = this.camelContext.getInjector().newInstance(transformerClass, false);
        }
        transformer.setCamelContext(this.camelContext);
        return transformer.setName(((CustomTransformerDefinition)this.definition).getScheme(), ((CustomTransformerDefinition)this.definition).getName()).setFrom(((CustomTransformerDefinition)this.definition).getFromType()).setTo(((CustomTransformerDefinition)this.definition).getToType());
    }
}

