/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.NonManagedService;
import org.apache.camel.Service;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.function.ThrowingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ServicePool<S extends Service>
extends ServiceSupport
implements NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePool.class);
    private final ThrowingFunction<Endpoint, S, Exception> creator;
    private final Function<S, Endpoint> getEndpoint;
    private final ConcurrentMap<Endpoint, Pool<S>> pool = new ConcurrentHashMap<Endpoint, Pool<S>>();
    private final ConcurrentMap<Endpoint, Pool<S>> singlePoolEvicted = new ConcurrentHashMap<Endpoint, Pool<S>>();
    private final int capacity;
    private final Map<S, S> cache;

    public ServicePool(ThrowingFunction<Endpoint, S, Exception> creator, Function<S, Endpoint> getEndpoint, int capacity) {
        this.creator = creator;
        this.getEndpoint = getEndpoint;
        this.capacity = capacity;
        this.cache = capacity > 0 ? LRUCacheFactory.newLRUCache(capacity, this::onEvict) : null;
    }

    protected void onEvict(S s2) {
        Endpoint e = this.getEndpoint.apply(s2);
        Pool p = (Pool)this.pool.get(e);
        if (p != null) {
            p.evict(s2);
            if (this.capacity > 0 && this.pool.size() > this.capacity) {
                p.stop();
            }
        } else {
            ServicePool.stop(s2);
            try {
                e.getCamelContext().removeService(s2);
            }
            catch (Exception ex) {
                LOG.debug("Error removing service: {}. This exception is ignored.", s2, (Object)ex);
            }
        }
    }

    public S acquire(Endpoint endpoint) throws Exception {
        if (!this.isStarted()) {
            return null;
        }
        Service s2 = (Service)this.getOrCreatePool(endpoint).acquire();
        if (s2 != null && this.cache != null) {
            this.cache.putIfAbsent(s2, s2);
        }
        return (S)s2;
    }

    public void release(Endpoint endpoint, S s2) {
        Pool p = (Pool)this.pool.get(endpoint);
        if (p != null) {
            p.release(s2);
        }
    }

    private Pool<S> getOrCreatePool(Endpoint endpoint) {
        Pool answer = (Pool)this.pool.get(endpoint);
        if (answer == null) {
            boolean singleton = endpoint.isSingletonProducer();
            answer = singleton ? this.pool.computeIfAbsent(endpoint, x$0 -> new SinglePool((Endpoint)x$0)) : this.pool.computeIfAbsent(endpoint, x$0 -> new MultiplePool((Endpoint)x$0));
        }
        return answer;
    }

    public int size() {
        return this.pool.values().stream().mapToInt(Pool::size).sum();
    }

    public void cleanUp() {
        Map<S, S> map = this.cache;
        if (map instanceof LRUCache) {
            LRUCache lru = (LRUCache)map;
            lru.cleanUp();
        }
        this.pool.values().forEach(Pool::cleanUp);
    }

    @Override
    protected void doStop() throws Exception {
        this.cleanUp();
        this.pool.values().forEach(Pool::stop);
        this.pool.clear();
        if (this.cache != null) {
            this.cache.values().forEach(ServicePool::stop);
            this.cache.clear();
        }
        this.singlePoolEvicted.values().forEach(Pool::stop);
        this.singlePoolEvicted.clear();
    }

    private static <S extends Service> void stop(S s2) {
        try {
            s2.stop();
        }
        catch (Exception e) {
            LOG.debug("Error stopping service: {}. This exception is ignored.", s2, (Object)e);
        }
    }

    private static interface Pool<S> {
        public S acquire() throws Exception;

        public void release(S var1);

        public int size();

        public void stop();

        public void evict(S var1);

        public void cleanUp();
    }

    private class MultiplePool
    implements Pool<S> {
        private final Endpoint endpoint;
        private final BlockingQueue<S> queue;
        private final Deque<S> evicts;

        MultiplePool(Endpoint endpoint) {
            this.endpoint = endpoint;
            this.queue = new ArrayBlockingQueue(ServicePool.this.capacity);
            this.evicts = new ConcurrentLinkedDeque();
        }

        private void cleanupEvicts() {
            Service evict = (Service)this.evicts.pollFirst();
            while (evict != null) {
                this.doStop(evict);
                evict = (Service)this.evicts.pollFirst();
            }
        }

        @Override
        public S acquire() throws Exception {
            this.cleanupEvicts();
            Service s2 = (Service)this.queue.poll();
            if (s2 == null) {
                s2 = (Service)ServicePool.this.creator.apply(this.endpoint);
                s2.start();
            }
            return s2;
        }

        @Override
        public void release(S s2) {
            this.cleanupEvicts();
            if (!this.queue.offer(s2)) {
                this.doStop((Service)s2);
            }
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void stop() {
            ArrayList<Service> list = new ArrayList<Service>();
            this.queue.drainTo(list);
            ServicePool.this.pool.remove(this.endpoint);
            list.forEach(this::doStop);
        }

        @Override
        public void evict(S s2) {
            this.evicts.add(s2);
        }

        @Override
        public void cleanUp() {
            this.cleanupEvicts();
        }

        void doStop(Service s2) {
            if (s2 != null) {
                ServicePool.stop(s2);
                try {
                    if (this.endpoint != null) {
                        this.endpoint.getCamelContext().removeService(s2);
                    }
                }
                catch (Exception e) {
                    LOG.debug("Error removing service: {}. This exception is ignored.", (Object)s2, (Object)e);
                }
            }
        }
    }

    private class SinglePool
    implements Pool<S> {
        private final Endpoint endpoint;
        private volatile S s;

        SinglePool(Endpoint endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint);
        }

        @Override
        public S acquire() throws Exception {
            this.cleanupEvicts();
            if (this.s == null) {
                ServicePool.this.lock.lock();
                try {
                    if (this.s == null) {
                        LOG.trace("Creating service from endpoint: {}", (Object)this.endpoint);
                        Service tempS = (Service)ServicePool.this.creator.apply(this.endpoint);
                        this.endpoint.getCamelContext().addService(tempS, true, true);
                        this.s = tempS;
                    }
                }
                finally {
                    ServicePool.this.lock.unlock();
                }
            }
            LOG.trace("Acquired service: {}", this.s);
            return this.s;
        }

        @Override
        public void release(S s2) {
            this.cleanupEvicts();
            LOG.trace("Released service: {}", s2);
        }

        @Override
        public int size() {
            return this.s != null ? 1 : 0;
        }

        @Override
        public void stop() {
            Object toStop;
            ServicePool.this.lock.lock();
            try {
                toStop = this.s;
                this.s = null;
            }
            finally {
                ServicePool.this.lock.unlock();
            }
            this.doStop((Service)toStop);
            ServicePool.this.pool.remove(this.endpoint);
        }

        @Override
        public void evict(S s2) {
            ServicePool.this.singlePoolEvicted.putIfAbsent(this.endpoint, this);
        }

        @Override
        public void cleanUp() {
            this.cleanupEvicts();
        }

        private void cleanupEvicts() {
            if (!ServicePool.this.singlePoolEvicted.isEmpty()) {
                for (Map.Entry entry : ServicePool.this.singlePoolEvicted.entrySet()) {
                    Endpoint e = (Endpoint)entry.getKey();
                    Pool p = (Pool)entry.getValue();
                    this.doStop(e);
                    p.stop();
                    ServicePool.this.singlePoolEvicted.remove(e);
                }
            }
        }

        void doStop(Service s2) {
            if (s2 != null) {
                ServicePool.stop(s2);
                try {
                    this.endpoint.getCamelContext().removeService(s2);
                }
                catch (Exception e) {
                    LOG.debug("Error removing service: {}. This exception is ignored.", (Object)s2, (Object)e);
                }
            }
        }
    }
}

