/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import java.util.Map;
import org.kiwiproject.consul.BaseClient;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.model.operator.RaftConfiguration;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public class OperatorClient
extends BaseClient {
    private static final String CLIENT_NAME = "operator";
    private final Api api;

    OperatorClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = retrofit.create(Api.class);
    }

    public RaftConfiguration getRaftConfiguration() {
        return this.http.extract(this.api.getConfiguration(Map.of()), new Integer[0]);
    }

    public RaftConfiguration getRaftConfiguration(String datacenter) {
        return this.http.extract(this.api.getConfiguration(Map.of("dc", datacenter)), new Integer[0]);
    }

    public RaftConfiguration getStaleRaftConfiguration(String datacenter) {
        return this.http.extract(this.api.getConfiguration(Map.of("dc", datacenter, "stale", "true")), new Integer[0]);
    }

    public RaftConfiguration getStaleRaftConfiguration() {
        return this.http.extract(this.api.getConfiguration(Map.of("stale", "true")), new Integer[0]);
    }

    public void deletePeer(String address) {
        this.http.handle(this.api.deletePeer(address, Map.of()), new Integer[0]);
    }

    public void deletePeer(String address, String datacenter) {
        this.http.handle(this.api.deletePeer(address, Map.of("dc", datacenter)), new Integer[0]);
    }

    static interface Api {
        @GET(value="operator/raft/configuration")
        public Call<RaftConfiguration> getConfiguration(@QueryMap Map<String, String> var1);

        @DELETE(value="operator/raft/peer")
        public Call<Void> deletePeer(@Query(value="address") String var1, @QueryMap Map<String, String> var2);
    }
}

