/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class ConsulResponse<T> {
    private final T response;
    private final long lastContact;
    private final boolean knownLeader;
    private final BigInteger index;
    private final Optional<CacheResponseInfo> cacheResponseInfo;

    @VisibleForTesting
    static CacheResponseInfo buildCacheResponseInfo(String headerHitMiss, String headerAge) throws NumberFormatException {
        CacheResponseInfoImpl cacheInfo = null;
        if (Objects.nonNull(headerHitMiss)) {
            cacheInfo = new CacheResponseInfoImpl(headerHitMiss, headerAge);
        }
        return cacheInfo;
    }

    public ConsulResponse(T response, long lastContact, boolean knownLeader, BigInteger index, String headerHitMiss, String headerAge) throws NumberFormatException {
        this(response, lastContact, knownLeader, index, Optional.ofNullable(ConsulResponse.buildCacheResponseInfo(headerHitMiss, headerAge)));
    }

    public ConsulResponse(T response, long lastContact, boolean knownLeader, BigInteger index, Optional<CacheResponseInfo> cacheInfo) {
        this.response = response;
        this.lastContact = lastContact;
        this.knownLeader = knownLeader;
        this.index = index;
        this.cacheResponseInfo = cacheInfo;
    }

    public T getResponse() {
        return this.response;
    }

    public long getLastContact() {
        return this.lastContact;
    }

    public boolean isKnownLeader() {
        return this.knownLeader;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    @Deprecated(since="1.1.0", forRemoval=true)
    public Optional<CacheResponseInfo> getCacheReponseInfo() {
        return this.getCacheResponseInfo();
    }

    public Optional<CacheResponseInfo> getCacheResponseInfo() {
        return this.cacheResponseInfo;
    }

    public String toString() {
        return "ConsulResponse{response=" + this.response + ", lastContact=" + this.lastContact + ", knownLeader=" + this.knownLeader + ", index=" + this.index + ", cache=" + this.cacheResponseInfo + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        ConsulResponse that = (ConsulResponse)o;
        return com.google.common.base.Objects.equal(this.response, that.response) && com.google.common.base.Objects.equal(this.lastContact, that.lastContact) && com.google.common.base.Objects.equal(this.knownLeader, that.knownLeader) && com.google.common.base.Objects.equal(this.index, that.index);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode(this.response, this.lastContact, this.knownLeader, this.index);
    }

    private static class CacheResponseInfoImpl
    implements CacheResponseInfo {
        private final Long ageInSeconds;
        private final boolean cacheHit;

        public CacheResponseInfoImpl(String headerHitMiss, String headerAge) throws NumberFormatException {
            this.cacheHit = headerHitMiss.equals("HIT");
            Long val = null;
            if (Objects.nonNull(headerAge)) {
                val = Long.parseLong(headerAge);
            }
            this.ageInSeconds = val;
        }

        @Override
        public Optional<Long> getAgeInSeconds() {
            return Optional.ofNullable(this.ageInSeconds);
        }

        @Override
        public boolean isCacheHit() {
            return this.cacheHit;
        }

        public String toString() {
            return String.format("Cache[%s, age=%d]", this.cacheHit ? "HIT" : "MISS", this.ageInSeconds);
        }
    }

    public static interface CacheResponseInfo {
        public Optional<Long> getAgeInSeconds();

        public boolean isCacheHit();
    }
}

