/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.acl.Role;

@Generated(from="Role.RoleNodeIdentity", generator="Immutables")
public final class ImmutableRoleNodeIdentity
extends Role.RoleNodeIdentity {
    private final String name;
    private final String datacenter;

    private ImmutableRoleNodeIdentity(String name, String datacenter) {
        this.name = name;
        this.datacenter = datacenter;
    }

    @Override
    @JsonProperty(value="NodeName")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String datacenter() {
        return this.datacenter;
    }

    public final ImmutableRoleNodeIdentity withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleNodeIdentity(newValue, this.datacenter);
    }

    public final ImmutableRoleNodeIdentity withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (this.datacenter.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleNodeIdentity(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleNodeIdentity && this.equalTo(0, (ImmutableRoleNodeIdentity)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleNodeIdentity another) {
        return this.name.equals(another.name) && this.datacenter.equals(another.datacenter);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.datacenter.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("RoleNodeIdentity").omitNullValues().add("name", this.name).add("datacenter", this.datacenter).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRoleNodeIdentity fromJson(Json json) {
        Builder builder = ImmutableRoleNodeIdentity.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        return builder.build();
    }

    public static ImmutableRoleNodeIdentity copyOf(Role.RoleNodeIdentity instance) {
        if (instance instanceof ImmutableRoleNodeIdentity) {
            return (ImmutableRoleNodeIdentity)instance;
        }
        return ImmutableRoleNodeIdentity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Role.RoleNodeIdentity", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DATACENTER = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String datacenter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Role.RoleNodeIdentity instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.datacenter(instance.datacenter());
            return this;
        }

        @JsonProperty(value="NodeName")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRoleNodeIdentity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoleNodeIdentity(this.name, this.datacenter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("datacenter");
            }
            return "Cannot build RoleNodeIdentity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Role.RoleNodeIdentity", generator="Immutables")
    static final class Json
    extends Role.RoleNodeIdentity {
        @Nullable
        String name;
        @Nullable
        String datacenter;

        Json() {
        }

        @JsonProperty(value="NodeName")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String datacenter() {
            throw new UnsupportedOperationException();
        }
    }
}

