/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.agent.Ports;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Ports", generator="Immutables")
public final class ImmutablePorts
extends Ports {
    private final int dns;
    private final int http;
    private final int rpc;
    private final int serfLan;
    private final int serfWan;
    private final int server;

    private ImmutablePorts(int dns, int http, int rpc, int serfLan, int serfWan, int server) {
        this.dns = dns;
        this.http = http;
        this.rpc = rpc;
        this.serfLan = serfLan;
        this.serfWan = serfWan;
        this.server = server;
    }

    @Override
    @JsonProperty(value="DNS")
    public int getDns() {
        return this.dns;
    }

    @Override
    @JsonProperty(value="HTTP")
    public int getHttp() {
        return this.http;
    }

    @Override
    @JsonProperty(value="RPC")
    public int getRpc() {
        return this.rpc;
    }

    @Override
    @JsonProperty(value="SerfLan")
    public int getSerfLan() {
        return this.serfLan;
    }

    @Override
    @JsonProperty(value="SerfWan")
    public int getSerfWan() {
        return this.serfWan;
    }

    @Override
    @JsonProperty(value="Server")
    public int getServer() {
        return this.server;
    }

    public final ImmutablePorts withDns(int value) {
        if (this.dns == value) {
            return this;
        }
        return new ImmutablePorts(value, this.http, this.rpc, this.serfLan, this.serfWan, this.server);
    }

    public final ImmutablePorts withHttp(int value) {
        if (this.http == value) {
            return this;
        }
        return new ImmutablePorts(this.dns, value, this.rpc, this.serfLan, this.serfWan, this.server);
    }

    public final ImmutablePorts withRpc(int value) {
        if (this.rpc == value) {
            return this;
        }
        return new ImmutablePorts(this.dns, this.http, value, this.serfLan, this.serfWan, this.server);
    }

    public final ImmutablePorts withSerfLan(int value) {
        if (this.serfLan == value) {
            return this;
        }
        return new ImmutablePorts(this.dns, this.http, this.rpc, value, this.serfWan, this.server);
    }

    public final ImmutablePorts withSerfWan(int value) {
        if (this.serfWan == value) {
            return this;
        }
        return new ImmutablePorts(this.dns, this.http, this.rpc, this.serfLan, value, this.server);
    }

    public final ImmutablePorts withServer(int value) {
        if (this.server == value) {
            return this;
        }
        return new ImmutablePorts(this.dns, this.http, this.rpc, this.serfLan, this.serfWan, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePorts && this.equalTo(0, (ImmutablePorts)another);
    }

    private boolean equalTo(int synthetic, ImmutablePorts another) {
        return this.dns == another.dns && this.http == another.http && this.rpc == another.rpc && this.serfLan == another.serfLan && this.serfWan == another.serfWan && this.server == another.server;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.dns;
        h2 += (h2 << 5) + this.http;
        h2 += (h2 << 5) + this.rpc;
        h2 += (h2 << 5) + this.serfLan;
        h2 += (h2 << 5) + this.serfWan;
        h2 += (h2 << 5) + this.server;
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Ports").omitNullValues().add("dns", this.dns).add("http", this.http).add("rpc", this.rpc).add("serfLan", this.serfLan).add("serfWan", this.serfWan).add("server", this.server).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePorts fromJson(Json json) {
        Builder builder = ImmutablePorts.builder();
        if (json.dnsIsSet) {
            builder.dns(json.dns);
        }
        if (json.httpIsSet) {
            builder.http(json.http);
        }
        if (json.rpcIsSet) {
            builder.rpc(json.rpc);
        }
        if (json.serfLanIsSet) {
            builder.serfLan(json.serfLan);
        }
        if (json.serfWanIsSet) {
            builder.serfWan(json.serfWan);
        }
        if (json.serverIsSet) {
            builder.server(json.server);
        }
        return builder.build();
    }

    public static ImmutablePorts copyOf(Ports instance) {
        if (instance instanceof ImmutablePorts) {
            return (ImmutablePorts)instance;
        }
        return ImmutablePorts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Ports", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DNS = 1L;
        private static final long INIT_BIT_HTTP = 2L;
        private static final long INIT_BIT_RPC = 4L;
        private static final long INIT_BIT_SERF_LAN = 8L;
        private static final long INIT_BIT_SERF_WAN = 16L;
        private static final long INIT_BIT_SERVER = 32L;
        private long initBits = 63L;
        private int dns;
        private int http;
        private int rpc;
        private int serfLan;
        private int serfWan;
        private int server;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Ports instance) {
            Objects.requireNonNull(instance, "instance");
            this.dns(instance.getDns());
            this.http(instance.getHttp());
            this.rpc(instance.getRpc());
            this.serfLan(instance.getSerfLan());
            this.serfWan(instance.getSerfWan());
            this.server(instance.getServer());
            return this;
        }

        @JsonProperty(value="DNS")
        @CanIgnoreReturnValue
        public final Builder dns(int dns) {
            this.dns = dns;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="HTTP")
        @CanIgnoreReturnValue
        public final Builder http(int http) {
            this.http = http;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="RPC")
        @CanIgnoreReturnValue
        public final Builder rpc(int rpc) {
            this.rpc = rpc;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="SerfLan")
        @CanIgnoreReturnValue
        public final Builder serfLan(int serfLan) {
            this.serfLan = serfLan;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="SerfWan")
        @CanIgnoreReturnValue
        public final Builder serfWan(int serfWan) {
            this.serfWan = serfWan;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Server")
        @CanIgnoreReturnValue
        public final Builder server(int server) {
            this.server = server;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutablePorts build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePorts(this.dns, this.http, this.rpc, this.serfLan, this.serfWan, this.server);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dns");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("http");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("rpc");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("serfLan");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("serfWan");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("server");
            }
            return "Cannot build Ports, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Ports", generator="Immutables")
    static final class Json
    extends Ports {
        int dns;
        boolean dnsIsSet;
        int http;
        boolean httpIsSet;
        int rpc;
        boolean rpcIsSet;
        int serfLan;
        boolean serfLanIsSet;
        int serfWan;
        boolean serfWanIsSet;
        int server;
        boolean serverIsSet;

        Json() {
        }

        @JsonProperty(value="DNS")
        public void setDns(int dns) {
            this.dns = dns;
            this.dnsIsSet = true;
        }

        @JsonProperty(value="HTTP")
        public void setHttp(int http) {
            this.http = http;
            this.httpIsSet = true;
        }

        @JsonProperty(value="RPC")
        public void setRpc(int rpc) {
            this.rpc = rpc;
            this.rpcIsSet = true;
        }

        @JsonProperty(value="SerfLan")
        public void setSerfLan(int serfLan) {
            this.serfLan = serfLan;
            this.serfLanIsSet = true;
        }

        @JsonProperty(value="SerfWan")
        public void setSerfWan(int serfWan) {
            this.serfWan = serfWan;
            this.serfWanIsSet = true;
        }

        @JsonProperty(value="Server")
        public void setServer(int server) {
            this.server = server;
            this.serverIsSet = true;
        }

        @Override
        public int getDns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHttp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRpc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSerfLan() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSerfWan() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getServer() {
            throw new UnsupportedOperationException();
        }
    }
}

