/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.health.ServiceHealth;
import org.kiwiproject.consul.model.query.QueryResults;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="QueryResults", generator="Immutables")
public final class ImmutableQueryResults
extends QueryResults {
    private final String service;
    private final ImmutableList<ServiceHealth> nodes;

    private ImmutableQueryResults(String service, ImmutableList<ServiceHealth> nodes) {
        this.service = service;
        this.nodes = nodes;
    }

    @Override
    @JsonProperty(value="Service")
    public String service() {
        return this.service;
    }

    @JsonProperty(value="Nodes")
    public ImmutableList<ServiceHealth> nodes() {
        return this.nodes;
    }

    public final ImmutableQueryResults withService(String value) {
        String newValue = Objects.requireNonNull(value, "service");
        if (this.service.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryResults(newValue, this.nodes);
    }

    public final ImmutableQueryResults withNodes(ServiceHealth ... elements) {
        ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResults(this.service, newValue);
    }

    public final ImmutableQueryResults withNodes(Iterable<? extends ServiceHealth> elements) {
        if (this.nodes == elements) {
            return this;
        }
        ImmutableList<ServiceHealth> newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueryResults(this.service, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryResults && this.equalTo(0, (ImmutableQueryResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueryResults another) {
        return this.service.equals(another.service) && this.nodes.equals(another.nodes);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.service.hashCode();
        h2 += (h2 << 5) + this.nodes.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryResults").omitNullValues().add("service", this.service).add("nodes", this.nodes).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQueryResults fromJson(Json json) {
        Builder builder = ImmutableQueryResults.builder();
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.nodes != null) {
            builder.addAllNodes(json.nodes);
        }
        return builder.build();
    }

    public static ImmutableQueryResults copyOf(QueryResults instance) {
        if (instance instanceof ImmutableQueryResults) {
            return (ImmutableQueryResults)instance;
        }
        return ImmutableQueryResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueryResults", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE = 1L;
        private long initBits = 1L;
        @Nullable
        private String service;
        private ImmutableList.Builder<ServiceHealth> nodes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueryResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.service(instance.service());
            this.addAllNodes(instance.nodes());
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(String service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodes(ServiceHealth element) {
            this.nodes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNodes(ServiceHealth ... elements) {
            this.nodes.add(elements);
            return this;
        }

        @JsonProperty(value="Nodes")
        @CanIgnoreReturnValue
        public final Builder nodes(Iterable<? extends ServiceHealth> elements) {
            this.nodes = ImmutableList.builder();
            return this.addAllNodes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNodes(Iterable<? extends ServiceHealth> elements) {
            this.nodes.addAll(elements);
            return this;
        }

        public ImmutableQueryResults build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryResults(this.service, (ImmutableList<ServiceHealth>)this.nodes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build QueryResults, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="QueryResults", generator="Immutables")
    static final class Json
    extends QueryResults {
        @Nullable
        String service;
        @Nullable
        List<ServiceHealth> nodes = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this.service = service;
        }

        @JsonProperty(value="Nodes")
        public void setNodes(List<ServiceHealth> nodes) {
            this.nodes = nodes;
        }

        @Override
        public String service() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ServiceHealth> nodes() {
            throw new UnsupportedOperationException();
        }
    }
}

