/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.component.controlbus.ControlBusEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="controlbus")
public class ControlBusComponent
extends DefaultComponent {
    private ExecutorService executorService;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ControlBusEndpoint answer = new ControlBusEndpoint(uri, this);
        if (remaining != null && remaining.startsWith("language:")) {
            String lan = remaining.substring(9);
            answer.setLanguage(this.getCamelContext().resolveLanguage(lan));
        }
        this.setProperties(answer, parameters);
        return answer;
    }

    ExecutorService getExecutorService() {
        this.lock.lock();
        try {
            if (this.executorService == null) {
                this.executorService = this.getCamelContext().getExecutorServiceManager().newDefaultThreadPool(this, "ControlBus");
            }
            ExecutorService executorService = this.executorService;
            return executorService;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
        super.doStop();
    }
}

