/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.service.kv.Observe;
import com.couchbase.client.core.service.kv.ObserveContext;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public class ClassicHelper {
    private ClassicHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static void setClientContext(Request<?> request, CoreCommonOptions common) {
        request.context().clientContext(common.clientContext());
    }

    public static <T, RES extends Response> CoreAsyncResponse<T> newAsyncResponse(Request<RES> request, CompletableFuture<T> future) {
        return new CoreAsyncResponse<T>(future, () -> request.cancel(CancellationReason.STOPPED_LISTENING));
    }

    public static <T extends CoreMutationResult> CompletableFuture<T> maybeWrapWithLegacyDurability(CompletableFuture<T> input, String key, CoreDurability durability, Core core, KeyValueRequest<?> request) {
        if (!durability.isLegacy()) {
            return input;
        }
        return input.thenCompose(result -> {
            ObserveContext ctx = new ObserveContext(core.context(), durability.legacyPersistTo(), durability.legacyReplicateTo(), result.mutationToken(), result.cas(), request.collectionIdentifier(), key, false, request.timeout(), request.requestSpan());
            return Observe.poll(ctx).toFuture().thenApply(v -> result);
        });
    }
}

