/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.io;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.io.IoContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import java.time.Duration;

public class SelectBucketFailedEvent
extends AbstractEvent {
    private final short status;

    public SelectBucketFailedEvent(Event.Severity severity, IoContext context, short status) {
        super(severity, Event.Category.IO, Duration.ZERO, (Context)context);
        this.status = status;
    }

    public short status() {
        return this.status;
    }

    @Override
    public String description() {
        if (this.status == MemcacheProtocol.Status.ACCESS_ERROR.status()) {
            return "Select bucket failed because of an access error (bucket does not exist or insufficient privileges) - status code 0x" + Integer.toHexString(this.status);
        }
        return "Select bucket failed with status code 0x" + Integer.toHexString(this.status);
    }
}

